/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.multistateconfiguration;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.system.element.multistateconfiguration.AbstractProperty;
import ch.nolix.system.element.multistateconfiguration.CascadingProperty;
import ch.nolix.system.element.multistateconfiguration.State;
import ch.nolix.system.element.multistateconfiguration.StateExtractor;
import ch.nolix.systemapi.element.multistateconfiguration.IMultiStateConfiguration;
import java.lang.reflect.Field;
import java.util.Iterator;

public abstract class AbstractMultiStateConfiguration<C extends IMultiStateConfiguration<C, S>, S extends Enum<S>>
extends AbstractElement
implements IMultiStateConfiguration<C, S> {
    private final State<S> baseState;
    private final IContainer<State<S>> availableStates;
    private IContainer<AbstractProperty<S>> abstractProperties;

    protected AbstractMultiStateConfiguration(S baseState) {
        Validator.assertThat(baseState).thatIsNamed("base state").isNotNull();
        this.availableStates = new StateExtractor<S>().createtStatesFromState(baseState);
        this.baseState = this.availableStates.getStoredFirst(s -> s.hasEnumValue(baseState));
    }

    private static boolean fieldStoresProperty(Field field) {
        return AbstractProperty.class.isAssignableFrom(field.getType());
    }

    @Override
    public final boolean addedOrChangedAttribute(INode<?> attribute) {
        for (AbstractProperty abstractProperty : this.getStoredProperties()) {
            if (!attribute.getHeader().endsWith(abstractProperty.getName())) continue;
            abstractProperty.setValueFromSpecification(attribute);
            return true;
        }
        return false;
    }

    @Override
    public final void addOrChangeAttribute(String attribtue, String ... attributes) {
        this.addOrChangeAttribute(Node.fromString(attribtue));
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            this.addOrChangeAttribute(Node.fromString(a));
            ++n2;
        }
    }

    @Override
    public final void addOrChangeAttribute(INode<?> attribute) {
        if (!this.addedOrChangedAttribute(attribute)) {
            throw InvalidArgumentException.forArgumentAndArgumentName(attribute, "attribute");
        }
    }

    @Override
    public final IContainer<INode<?>> getAttributes() {
        LinkedList<INode<?>> attributes = LinkedList.createEmpty();
        for (AbstractProperty abstractProperty : this.getStoredProperties()) {
            abstractProperty.fillUpValuesSpecificationInto(attributes);
        }
        return attributes;
    }

    @Override
    public final S getBaseState() {
        return this.baseState.getEnumValue();
    }

    @Override
    public final void reset() {
        this.getStoredProperties().forEach(AbstractProperty::setUndefined);
    }

    public final void setFrom(C element) {
        Iterator iterator = ((AbstractMultiStateConfiguration)element).getStoredProperties().iterator();
        for (AbstractProperty abstractProperty : this.getStoredProperties()) {
            abstractProperty.setFrom((AbstractProperty)iterator.next());
        }
    }

    protected final C asConcrete() {
        return (C)this;
    }

    protected final void internalAddChild(C child) {
        Validator.assertThat(child).thatIsNamed("child").isNotNull();
        ((AbstractMultiStateConfiguration)child).setParent(this);
    }

    protected final void initialize() {
        this.extractPropertiesIfNotExtracted();
    }

    final IContainer<State<S>> getAvailableStates() {
        return this.availableStates;
    }

    final State<S> getBaseStateObject() {
        return this.baseState;
    }

    final IContainer<AbstractProperty<S>> getStoredProperties() {
        this.extractPropertiesIfNotExtracted();
        return this.abstractProperties;
    }

    final State<S> getStateObjectFor(S state) {
        for (State state2 : this.availableStates) {
            if (!state2.hasEnumValue(state)) continue;
            return state2;
        }
        throw InvalidArgumentException.forArgument(state);
    }

    private void extractPropertiesIfNotExtracted() {
        if (!this.propertiesAreExtracted()) {
            this.extractPropertiesWhenNotExtracted();
        }
    }

    private void extractPropertiesWhenNotExtracted() {
        LinkedList<AbstractProperty<S>> lProperties = LinkedList.createEmpty();
        this.fillUpPropertiesIntoList(lProperties);
        this.abstractProperties = lProperties;
        this.setItselsAsParentToProperties();
    }

    private void fillUpPotentialPropertyFromFieldIntoList(Field field, ILinkedList<AbstractProperty<S>> list) {
        if (AbstractMultiStateConfiguration.fieldStoresProperty(field)) {
            list.addAtEnd(this.getPropertyFromField(field));
        }
    }

    private void fillUpPropertiesIntoList(ILinkedList<AbstractProperty<S>> list) {
        Class<?> lClass = this.getClass();
        while (lClass != null) {
            this.fillUpPropertiesFromClassIntoList(lClass, list);
            lClass = lClass.getSuperclass();
        }
    }

    private void fillUpPropertiesFromClassIntoList(Class<?> pClass, ILinkedList<AbstractProperty<S>> list) {
        Field[] fieldArray = pClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            this.fillUpPotentialPropertyFromFieldIntoList(f, list);
            ++n2;
        }
    }

    private AbstractProperty<S> getPropertyFromField(Field field) {
        try {
            field.setAccessible(true);
            AbstractProperty property = (AbstractProperty)field.get(this);
            Validator.assertThat(property).isOfType(AbstractProperty.class);
            return property;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrapperException.forError(illegalAccessException);
        }
    }

    private IContainer<CascadingProperty<S, ?>> getStoredCascadingProperties() {
        return this.getStoredProperties().getStoredOfType(CascadingProperty.class);
    }

    private boolean propertiesAreExtracted() {
        return this.abstractProperties != null;
    }

    private void setItselsAsParentToProperties() {
        for (AbstractProperty abstractProperty : this.getStoredProperties()) {
            abstractProperty.setParent(this);
        }
    }

    private void setParent(AbstractMultiStateConfiguration<?, S> parentElement) {
        LinkedList<CascadingProperty<S, ?>> parentCascadingProperties = LinkedList.fromIterable(parentElement.getStoredCascadingProperties());
        for (CascadingProperty cascadingProperty : this.getStoredCascadingProperties()) {
            cascadingProperty.setParentProperty(parentCascadingProperties.removeAndGetStoredFirst(pp -> pp.hasSameNameAs(p)));
        }
        Validator.assertThat(parentCascadingProperties).thatIsNamed("remaining parent cascading properties").isEmpty();
    }
}

