/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.commontypetool.stringtool.StringTool;
import ch.nolix.core.environment.runningjar.RunningJar;
import ch.nolix.core.errorcontrol.validator.Validator;

public final class SslServerPage {
    private static final String REQUIRE_JS_SCRIPT = RunningJar.getResource("script/require_js.js");
    private static final String NOLIX_SCRIPT = RunningJar.getResource("script/nolix.js");
    private final String domain;
    private final int port;

    private SslServerPage(String domain, int port) {
        Validator.assertThat(domain).thatIsNamed("domain").isNotBlank();
        Validator.assertThat(port).thatIsNamed("port").isPort();
        this.domain = domain;
        this.port = port;
    }

    public static SslServerPage forDomainAndPort(String domain, int port) {
        return new SslServerPage(domain, port);
    }

    public String toString() {
        return "<!DOCTYPE html>\n<html>\n<head>\n<link id=\"icon\" rel=\"icon\" href=\"data:,\">\n<script>\n" + REQUIRE_JS_SCRIPT + "</script>\n<script>\n" + NOLIX_SCRIPT + "</script>\n" + this.getStartScript() + "<title\n>Nolix\n</title>\n</head>\n<body>\n</body>\n</html>\n";
    }

    public String getDomain() {
        return this.domain;
    }

    public int getPort() {
        return this.port;
    }

    private String getServerDomainInQuotes() {
        return StringTool.getInSingleQuotes(this.getDomain());
    }

    private String getStartScript() {
        return "<script>\nrequire(['System/Application/WebApplication/FrontendWebClient'], function (FrontendWebClient_) {var client = FrontendWebClient_.FrontendWebClient.toIpAndPortAndApplicationFromURLOnSecureWebSocket(" + this.getServerDomainInQuotes() + ", " + this.getPort() + ");});\n</script>\n";
    }
}

