/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.net.ssl.NolixConfigurationSSLCertificateReader;
import ch.nolix.core.net.target.ServerTarget;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;
import ch.nolix.coreapi.net.ssl.ISslCertificate;
import ch.nolix.coreapi.net.target.IServerTarget;
import ch.nolix.system.application.main.AbstractServer;
import ch.nolix.system.application.main.Application;
import ch.nolix.system.application.main.ServerSlot;
import ch.nolix.system.application.main.SslServerPage;
import ch.nolix.systemapi.application.main.IApplication;

public final class SslServer
extends AbstractServer<SslServer> {
    public static final int DEFAULT_PORT = 443;
    private static final SecurityMode SECURITY_MODE_FOR_CONNECTIONS = SecurityMode.SSL;
    private static final NolixConfigurationSSLCertificateReader NOLIX_CONFIUGEATION_SSL_CERTIFICATE_READER = new NolixConfigurationSSLCertificateReader();
    private final ch.nolix.core.net.endpoint3.SslServer internalWebSocketServer;
    private final String domain;
    private final int port;

    public SslServer(int port, String domain, ISslCertificate paramSSLCertificate) {
        SslServerPage htmlPage = SslServerPage.forDomainAndPort(domain, port);
        String htmlPageAsString = htmlPage.toString();
        this.internalWebSocketServer = ch.nolix.core.net.endpoint3.SslServer.forPortAndHtmlPageAndSSLCertificate(port, htmlPageAsString, paramSSLCertificate);
        this.domain = domain;
        this.port = port;
        this.createCloseDependencyTo(this.internalWebSocketServer);
    }

    public static SslServer forHttpsPortAndDomainAndSSLCertificateFromNolixConfiguration() {
        String domain = NOLIX_CONFIUGEATION_SSL_CERTIFICATE_READER.getDefaultDomainFromLocalNolixConfiguration();
        ISslCertificate paramSSLCertificate = NOLIX_CONFIUGEATION_SSL_CERTIFICATE_READER.getDefaultSSLCertificatefromLocalNolixConfiguration();
        return new SslServer(443, domain, paramSSLCertificate);
    }

    public static SslServer forDefaultPortAndDomainAndSSLCertificateFromNolixConfiguration(String domain) {
        ISslCertificate paramSSLCertificate = NOLIX_CONFIUGEATION_SSL_CERTIFICATE_READER.getDefaultSSLCertificatefromLocalNolixConfiguration();
        return new SslServer(443, domain, paramSSLCertificate);
    }

    public static SslServer forPortAndDomainAndSSLCertificateFromNolixConfiguration(int port, String domain) {
        ISslCertificate paramSSLCertificate = NOLIX_CONFIUGEATION_SSL_CERTIFICATE_READER.getDefaultSSLCertificatefromLocalNolixConfiguration();
        return new SslServer(port, domain, paramSSLCertificate);
    }

    @Override
    public IServerTarget asTarget() {
        return ServerTarget.forIpOrDomainAndPortAndSecurityModeForConnections(this.domain, this.port, SECURITY_MODE_FOR_CONNECTIONS);
    }

    @Override
    public SecurityMode getSecurityMode() {
        return this.internalWebSocketServer.getSecurityMode();
    }

    @Override
    protected SslServer asConcrete() {
        return this;
    }

    @Override
    protected void noteAddedApplication(Application<?, ?> application) {
        this.internalWebSocketServer.addSlot(new ServerSlot(application.getUrlInstanceName(), this));
    }

    @Override
    protected void noteAddedDefaultApplication(Application<?, ?> defaultApplication) {
        this.internalWebSocketServer.addDefaultSlot(new ServerSlot(defaultApplication.getUrlInstanceName(), this));
    }

    @Override
    protected void noteRemovedApplication(IApplication<?, ?> application) {
        this.internalWebSocketServer.removeSlotByName(application.getUrlInstanceName());
    }
}

