/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.net.endpoint3.LocalEndPoint;
import ch.nolix.core.net.endpoint3.NetEndPoint;
import ch.nolix.system.application.main.AbstractClient;
import ch.nolix.system.application.main.AbstractServer;
import ch.nolix.system.application.main.Application;

public abstract class AbstractFrontendClient<C extends AbstractFrontendClient<C>>
extends AbstractClient<C> {
    @Override
    public final boolean isOnBackend() {
        return false;
    }

    protected final void connectTo(Application<?, ?> application) {
        LocalEndPoint endPoint = new LocalEndPoint();
        this.setEndPoint(endPoint);
        application.takeEndPoint(endPoint.getStoredCounterpart());
    }

    protected final void connectTo(AbstractServer<?> server) {
        LocalEndPoint endPoint = new LocalEndPoint();
        this.setEndPoint(endPoint);
        server.getStoredDefaultApplication().takeEndPoint(endPoint.getStoredCounterpart());
    }

    protected final void connectTo(int port) {
        this.setEndPoint(new NetEndPoint(port));
    }

    protected final void connectTo(int port, String name) {
        this.setEndPoint(new NetEndPoint(port, name));
    }

    protected final void connectTo(AbstractServer<?> server, String instanceName) {
        LocalEndPoint endPoint = new LocalEndPoint();
        this.setEndPoint(endPoint);
        server.getStoredApplicationByInstanceName(instanceName).takeEndPoint(endPoint.getStoredCounterpart());
    }

    protected final void connectTo(String ip) {
        this.setEndPoint(new NetEndPoint(ip));
    }

    protected final void connectTo(String ip, int port) {
        this.setEndPoint(new NetEndPoint(ip, port));
    }

    protected final void connectTo(String ip, int port, String name) {
        this.setEndPoint(new NetEndPoint(ip, port, name));
    }
}

