/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.net.target.IApplicationInstanceTarget;
import ch.nolix.system.application.main.AbstractClient;
import ch.nolix.system.application.main.AbstractSession;
import ch.nolix.system.application.main.Application;
import ch.nolix.system.application.main.BackendClientSessionManager;
import ch.nolix.systemapi.application.client.IBackendClient;

public abstract class AbstractBackendClient<C extends AbstractBackendClient<C, S>, S>
extends AbstractClient<C>
implements IBackendClient<S> {
    private final BackendClientSessionManager<C, S> sessionManager = BackendClientSessionManager.forClient(this);
    private Application<C, S> memberParentApplication;

    public final String getApplicationName() {
        return this.getStoredParentApplication().getInstanceName();
    }

    @Override
    public final IApplicationInstanceTarget getApplicationAsTarget() {
        return this.getStoredParentApplication().asTarget();
    }

    @Override
    public final S getStoredApplicationService() {
        return this.getStoredParentApplication().getStoredApplicationService();
    }

    @Override
    public final boolean isOnBackend() {
        return true;
    }

    @Override
    public final void noteClose() {
        while (this.sessionManager.containsCurrentSession()) {
            this.sessionManager.popCurrentSession();
        }
    }

    protected final AbstractSession<C, S> getStoredCurrentSession() {
        return this.sessionManager.getStoredCurrentSession();
    }

    final int internalGetSessionStackSize() {
        return this.sessionManager.getSessionStackSize();
    }

    final void internalPopCurrentSession() {
        this.sessionManager.popCurrentSession();
    }

    final void internalPopCurrentSessionAndForwardGivenResult(Object result) {
        this.sessionManager.popCurrentSessionAndForwardGivenResult(result);
    }

    final void internalPush(AbstractSession<C, S> session) {
        this.sessionManager.pushSession(session);
    }

    final <R> R internalPushAndGetResult(AbstractSession<C, S> session) {
        return this.sessionManager.pushSessionAndGetResult(session);
    }

    final void internalSetCurrentSession(AbstractSession<C, S> session) {
        this.sessionManager.setCurrentSession(session);
    }

    final void internalSetParentApplication(Application<C, S> parentApplication) {
        Validator.assertThat(parentApplication).thatIsNamed("parent application").isNotNull();
        this.assertDoesNotReferenceParentApplication();
        this.memberParentApplication = parentApplication;
    }

    private void assertDoesNotReferenceParentApplication() {
        if (this.referencesParentApplication()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "references already its parent application");
        }
    }

    private void assertReferencesParentApplication() {
        if (!this.referencesParentApplication()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "does not reference its parent application");
        }
    }

    private Application<C, S> getStoredParentApplication() {
        this.assertReferencesParentApplication();
        return this.memberParentApplication;
    }

    private boolean referencesParentApplication() {
        return this.memberParentApplication != null;
    }
}

