/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.coreapi.net.websocket;

public enum WebSocketFrameOpcodeMeaning {
    CONTINUATION_FRAME,
    TEXT_FRAME,
    BINARY_FRAME,
    CONNECTION_CLOSE,
    PING,
    PONG,
    RESERVED;


    public static WebSocketFrameOpcodeMeaning fromNumber(int number) {
        return switch (number) {
            case 0 -> CONTINUATION_FRAME;
            case 1 -> TEXT_FRAME;
            case 2 -> BINARY_FRAME;
            case 3, 4, 5, 6, 7 -> RESERVED;
            case 8 -> CONNECTION_CLOSE;
            case 9 -> PING;
            case 10 -> PONG;
            case 11, 12, 13, 14, 15 -> RESERVED;
            default -> throw new IllegalArgumentException("The given number '" + number + "' does not represent a WebSocketFrameOpcodeMeaning.");
        };
    }

    public int toNumber() {
        return switch (this) {
            case CONTINUATION_FRAME -> 0;
            case TEXT_FRAME -> 1;
            case BINARY_FRAME -> 2;
            case CONNECTION_CLOSE -> 8;
            case PING -> 9;
            case PONG -> 10;
            case RESERVED -> throw new IllegalArgumentException("The current WebSocketFrameOpcodeMeaning does not represent a number.");
            default -> throw new IllegalArgumentException("The current WebSocketFrameOpcodeMeaning does not represent a number.");
        };
    }
}

