/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.web.htmlelementmodel;

import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;

public final class HtmlElementStringRepresentator {
    private HtmlElementStringRepresentator() {
    }

    public static String toString(IHtmlElement htmlElement) {
        if (!htmlElement.containsChildElements()) {
            return HtmlElementStringRepresentator.toStringWhenDoesNotContainChildElements(htmlElement);
        }
        return HtmlElementStringRepresentator.toStringWhenContainsChildElements(htmlElement);
    }

    private static String toStringWhenDoesNotContainChildElements(IHtmlElement htmlElement) {
        if (htmlElement.getInnerText().isEmpty()) {
            return HtmlElementStringRepresentator.toStringWhenDoesNotContainChildElementsAndHasEmptyInnerText(htmlElement);
        }
        return HtmlElementStringRepresentator.toStringWhenDoesNotContainChildElementsAndHasNonEmptyInnerText(htmlElement);
    }

    private static String toStringWhenDoesNotContainChildElementsAndHasEmptyInnerText(IHtmlElement htmlElement) {
        if (!htmlElement.containsAttributes()) {
            return "<" + htmlElement.getType() + " />";
        }
        return "<" + htmlElement.getType() + " " + HtmlElementStringRepresentator.getAttributesAsString(htmlElement) + " />";
    }

    private static String toStringWhenDoesNotContainChildElementsAndHasNonEmptyInnerText(IHtmlElement htmlElement) {
        if (!htmlElement.containsAttributes()) {
            return "<" + htmlElement.getType() + ">" + htmlElement.getInnerText() + "</" + htmlElement.getType() + ">";
        }
        return "<" + htmlElement.getType() + " " + HtmlElementStringRepresentator.getAttributesAsString(htmlElement) + ">" + htmlElement.getInnerText() + "</" + htmlElement.getType() + ">";
    }

    private static String toStringWhenContainsChildElements(IHtmlElement htmlElement) {
        if (htmlElement.getInnerText().isEmpty()) {
            return HtmlElementStringRepresentator.toStringWhenContainsChildElementsAndHasEmptyInnerText(htmlElement);
        }
        return HtmlElementStringRepresentator.toStringWhenContainsChildElementsAndHasNonEmptyInnerText(htmlElement);
    }

    private static String toStringWhenContainsChildElementsAndHasEmptyInnerText(IHtmlElement htmlElement) {
        if (!htmlElement.containsAttributes()) {
            return "<" + htmlElement.getType() + ">" + HtmlElementStringRepresentator.getChildElementsAsString(htmlElement) + "</" + htmlElement.getType() + ">";
        }
        return "<" + htmlElement.getType() + " " + HtmlElementStringRepresentator.getAttributesAsString(htmlElement) + ">" + HtmlElementStringRepresentator.getChildElementsAsString(htmlElement) + "</" + htmlElement.getType() + ">";
    }

    private static String toStringWhenContainsChildElementsAndHasNonEmptyInnerText(IHtmlElement htmlElement) {
        if (!htmlElement.containsAttributes()) {
            return "<" + htmlElement.getType() + ">" + htmlElement.getInnerText() + HtmlElementStringRepresentator.getChildElementsAsString(htmlElement) + "</" + htmlElement.getType() + ">";
        }
        return "<" + htmlElement.getType() + " " + HtmlElementStringRepresentator.getAttributesAsString(htmlElement) + ">" + htmlElement.getInnerText() + HtmlElementStringRepresentator.getChildElementsAsString(htmlElement) + "</" + htmlElement.getType() + ">";
    }

    private static String getChildElementsAsString(IHtmlElement htmlElement) {
        return htmlElement.getChildElements().toStringWithSeparator("");
    }

    private static String getAttributesAsString(IHtmlElement htmlElement) {
        return htmlElement.getAttributes().toStringWithSeparator(" ");
    }
}

