/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.web.cssmodel;

import ch.nolix.core.commontypetool.stringtool.StringTool;
import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.web.cssmodel.CssProperty;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.cssmodel.ICssProperty;
import ch.nolix.coreapi.web.cssmodel.ICssRule;

public final class CssRule
implements ICssRule {
    private final String selector;
    private final IContainer<CssProperty> properties;

    private CssRule(String selector, IContainer<? extends ICssProperty> properties) {
        Validator.assertThat(selector).thatIsNamed("selector").isNotNull();
        this.properties = properties.to(CssProperty::fromCssProperty);
        this.selector = selector;
    }

    public static CssRule fromCssRule(ICssRule cssRule) {
        return CssRule.withSelectorAndProperties(cssRule.getSelector(), cssRule.getProperties());
    }

    public static CssRule withSelectorAndProperties(String selector, IContainer<? extends ICssProperty> properties) {
        return new CssRule(selector, properties);
    }

    public static CssRule withSelectorAndProperty(String selector, ICssProperty property, ICssProperty ... properties) {
        ContainerView<ICssProperty> allProperties = ContainerView.forElementAndArray(property, properties);
        return new CssRule(selector, allProperties);
    }

    public IContainer<CssProperty> getProperties() {
        return this.properties;
    }

    @Override
    public String getSelector() {
        return this.selector;
    }

    public String toString() {
        return this.getSelector() + StringTool.getInBraces(this.getProperties().toConcatenatedString());
    }

    @Override
    public ICssRule withPrefixedSelector(String selectorPrefix) {
        Validator.assertThat(selectorPrefix).thatIsNamed("selector prefix").isNotNull();
        String prefixedSelector = selectorPrefix + this.getSelector();
        return CssRule.withSelectorAndProperties(prefixedSelector, this.getProperties());
    }
}

