/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.testing.standardtest;

import ch.nolix.core.errorcontrol.generalexception.GeneralException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;

public class ThrownExceptionMediator {
    private final Throwable exception;

    ThrownExceptionMediator() {
        this.exception = null;
    }

    ThrownExceptionMediator(Throwable exception) {
        if (exception == null) {
            throw ArgumentIsNullException.forArgumentType(Exception.class);
        }
        this.exception = exception;
    }

    public final void withMessage() {
        if (this.exception != null && this.exception.getMessage() == null) {
            throw GeneralException.withErrorMessage("An exception with a message was expected,but an exception without messag was received.");
        }
    }

    public final void withMessage(String message) {
        if (message == null) {
            throw ArgumentIsNullException.forArgumentName("message");
        }
        if (this.exception != null) {
            if (this.exception.getMessage() == null) {
                throw GeneralException.withErrorMessage("An exception with the message '" + message + "' was expected, but an exception without messag was received.");
            }
            if (!this.exception.getMessage().equals(message)) {
                throw GeneralException.withErrorMessage("An exception with the message '" + message + "' was expected, but an exception with the message '" + this.exception.getMessage() + "' was thrown.");
            }
        }
    }

    public final void withMessageThatMatches(String regex) {
        if (regex == null) {
            throw ArgumentIsNullException.forArgumentName("regex");
        }
        String message = this.exception.getMessage();
        if (message == null) {
            throw GeneralException.withErrorMessage("An exception with a message that matches the regex '" + regex + "' was expected, but an exception without message was thrown.");
        }
        if (!message.matches(regex)) {
            throw GeneralException.withErrorMessage("An exception with a message that matches the regex '" + regex + "' was expected, but an exception with the message '" + message + "' was thrown.");
        }
    }

    public final void withoutMessage() {
        if (this.exception != null && this.exception.getMessage() != null) {
            throw GeneralException.withErrorMessage("An exception without message was expected, but an exception with the message '" + this.exception.getMessage() + "' was received.");
        }
    }

    final Throwable getException() {
        if (this.exception == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "exception");
        }
        return this.exception;
    }

    final boolean hasException() {
        return this.exception != null;
    }
}

