/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.testing.standardtest;

import ch.nolix.core.errorcontrol.generalexception.GeneralException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.testing.standardtest.ExtendedThrownExceptionMediator;

public final class ClosureMediator {
    private final Runnable closure;

    private ClosureMediator(Runnable closure) {
        if (closure == null) {
            throw ArgumentIsNullException.forArgumentName("closure");
        }
        this.closure = closure;
    }

    public static ClosureMediator forClosure(Runnable closure) {
        return new ClosureMediator(closure);
    }

    public ExtendedThrownExceptionMediator throwsException() {
        try {
            this.closure.run();
            throw GeneralException.withErrorMessage("An exception was expected, but no exception was thrown.");
        }
        catch (Throwable exception) {
            return new ExtendedThrownExceptionMediator(exception);
        }
    }

    public void doesNotThrowException() {
        try {
            this.closure.run();
        }
        catch (Throwable exception) {
            String message = exception.getMessage();
            if (message == null || message.isBlank()) {
                throw GeneralException.withErrorMessage("An exception was not expected, but a " + exception.getClass().getName() + " was thrown.");
            }
            throw GeneralException.withErrorMessage("An exception was not expected, but a " + exception.getClass().getName() + " was thrown with the message '" + message + "'");
        }
    }
}

