/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.sql.connectionpool;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnsupportedCaseException;
import ch.nolix.core.sql.connection.AbstractSqlConnection;
import ch.nolix.core.sql.connection.MsSqlConnection;
import ch.nolix.core.sql.connectionpool.SqlConnectionPool;

public final class SqlConnectionFactory {
    private SqlConnectionFactory() {
    }

    public static AbstractSqlConnection createSqlConnectionForSqlConnectionPool(SqlConnectionPool sqlConnectionPool) {
        switch (sqlConnectionPool.getSqlDatabaseEngine()) {
            case MSSQL: {
                break;
            }
            case MYSQL: 
            case ORACLE: {
                throw UnsupportedCaseException.forCase(sqlConnectionPool.getSqlDatabaseEngine());
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)sqlConnectionPool.getSqlDatabaseEngine());
            }
        }
        return SqlConnectionFactory.createMsSqlConnectionForSqlConnectionPool(sqlConnectionPool);
    }

    private static MsSqlConnection createMsSqlConnectionForSqlConnectionPool(SqlConnectionPool sqlConnectionPool) {
        return new MsSqlConnection(sqlConnectionPool.getIpOrDomain(), sqlConnectionPool.getPort(), sqlConnectionPool.getLoginName(), sqlConnectionPool.getLoginPassword());
    }
}

