/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.sql.connection;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.sql.model.SqlRecord;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.sql.model.ISqlRecord;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public final class SqlConnectionHelper {
    private SqlConnectionHelper() {
    }

    public static IContainer<ISqlRecord> getRecordsFromStatement(String query, Statement statement) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ResultSet resultSet = statement.executeQuery(query);){
            return SqlConnectionHelper.getRecordsFromResultSet(resultSet);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static IContainer<ISqlRecord> getRecordsFromResultSet(ResultSet resultSet) throws SQLException {
        LinkedList<ISqlRecord> sqlRecords = LinkedList.createEmpty();
        int columnCount = resultSet.getMetaData().getColumnCount();
        int index = 1;
        while (resultSet.next()) {
            List<String> entries = List.of();
            int i = 1;
            while (i <= columnCount) {
                String entry = resultSet.getString(i);
                entries.add(entry);
                ++i;
            }
            SqlRecord sqlRecord = SqlRecord.withOneBasedIndexAndValues(index, entries);
            sqlRecords.addAtEnd(sqlRecord);
            ++index;
        }
        return sqlRecords;
    }
}

