/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.resourcecontrol.resourcepool;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentBelongsToParentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.core.resourcecontrol.resourcepool.AbstractResourcePool;
import ch.nolix.coreapi.resourcecontrol.closecontroller.CloseStateRequestable;
import ch.nolix.coreapi.resourcecontrol.closecontroller.GroupCloseable;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;

public abstract class AbstractWrapperResource<W extends AbstractWrapperResource<W, R>, R extends GroupCloseable>
implements GroupCloseable {
    private AbstractResourcePool<W, R> memberParentResourcePool;
    private final R resource;
    private final ICloseController closeController = CloseController.forElement(this);

    protected AbstractWrapperResource(R resource) {
        Validator.assertThat(resource).fulfills(CloseStateRequestable::isOpen);
        this.resource = resource;
    }

    @Override
    public final ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public final void noteClose() {
        this.memberParentResourcePool.internalTakeBackResource(this.resource);
    }

    protected final R getStoredResource() {
        return this.resource;
    }

    final void internalSetParentResourcePool(AbstractResourcePool<W, R> parentResourcePool) {
        Validator.assertThat(parentResourcePool).thatIsNamed("parent resource pool").fulfills(CloseStateRequestable::isOpen);
        this.assertDoesNotBelongToResourcePool();
        this.memberParentResourcePool = parentResourcePool;
    }

    private void assertDoesNotBelongToResourcePool() {
        if (this.belongsToResourcePool()) {
            throw ArgumentBelongsToParentException.forArgumentAndParent(this, this.memberParentResourcePool);
        }
    }

    private boolean belongsToResourcePool() {
        return this.memberParentResourcePool != null;
    }
}

