/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.reflection.reflectiontool;

import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.coreapi.reflection.reflectiontool.IObjectTool;
import java.lang.reflect.Field;

public final class ObjectTool
implements IObjectTool {
    @Override
    public String getNameOfFirstFieldThatHasValue(Object object, Object value) {
        Field field = this.getStoredFirstFieldThatHasValue(object, value);
        return field.getName();
    }

    @Override
    public Field getStoredFirstFieldThatHasValue(Object object, Object value) {
        Class<?> localClass = object.getClass();
        while (localClass != null) {
            Field[] fieldArray = localClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                Object fieldValue = this.getStoredValueOfField(object, f);
                if (fieldValue == value) {
                    return f;
                }
                ++n2;
            }
            localClass = localClass.getSuperclass();
        }
        if (value != null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeType(object, value.getClass());
        }
        throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(object, "null");
    }

    @Override
    public Object getStoredValueOfField(Object object, Field field) {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrapperException.forError(illegalAccessException);
        }
    }
}

