/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.jobpool;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;

final class JobWrapper
implements Runnable {
    private boolean finished;
    private boolean running;
    private final Runnable job;
    private Throwable error;

    public JobWrapper(Runnable job) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        this.job = job;
    }

    public boolean caughtError() {
        return this.error != null;
    }

    public Throwable getError() {
        if (!this.caughtError()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "error");
        }
        return this.error;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isFresh() {
        return !this.isRunning() && !this.isFinished();
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        this.assertIsFresh();
        this.running = true;
        try {
            try {
                this.job.run();
            }
            catch (Throwable lError) {
                this.error = lError;
                this.running = false;
                this.finished = true;
            }
        }
        finally {
            this.running = false;
            this.finished = true;
        }
    }

    public void waitUntilIsFinished() {
        FlowController.waitUntil(this::isFinished);
    }

    public void waitUntilIsFinished(int timeoutInMilliseconds) {
        long startTimeInMilliseconds = System.currentTimeMillis();
        FlowController.waitAsLongAs(() -> System.currentTimeMillis() - startTimeInMilliseconds < (long)timeoutInMilliseconds && !this.isFinished());
        if (!this.isFinished()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "reached timeout before having finished");
        }
    }

    private void assertIsFresh() {
        if (this.isRunning()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is already running");
        }
        if (this.isFinished()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is already finished");
        }
    }
}

