/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.core.programcontrol.flowcontrol.ResultJobExecutor;
import ch.nolix.core.programcontrol.future.AbstractFuture;
import ch.nolix.coreapi.programcontrol.future.IResultFuture;

public final class ResultFuture<R>
extends AbstractFuture
implements IResultFuture<R> {
    private final ResultJobExecutor<R> resultJobExecutor;

    ResultFuture(ResultJobExecutor<R> resultJobRunner) {
        Validator.assertThat(resultJobRunner).isOfType(ResultJobExecutor.class);
        this.resultJobExecutor = resultJobRunner;
    }

    @Override
    public boolean caughtError() {
        return this.resultJobExecutor.caughtError();
    }

    @Override
    public Throwable getError() {
        return this.resultJobExecutor.getError();
    }

    @Override
    public R getResult() {
        return this.resultJobExecutor.getResult();
    }

    @Override
    public boolean isFinished() {
        return this.resultJobExecutor.isFinished();
    }

    @Override
    public void waitUntilIsFinished() {
        FlowController.waitUntil(this::isFinished);
    }

    @Override
    public void waitUntilIsFinished(int timeoutInMilliseconds) {
        long startTimeInMilliseconds = System.currentTimeMillis();
        FlowController.waitAsLongAs(() -> System.currentTimeMillis() - startTimeInMilliseconds < (long)timeoutInMilliseconds && this.isRunning());
        if (!this.isFinished()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "reached timeout before having finished");
        }
    }

    @Override
    public R waitUntilIsFinishedAndGetResult() {
        this.waitUntilIsFinished();
        return this.getResult();
    }
}

