/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.logging.Logger;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.Waiter;
import ch.nolix.core.programcontrol.job.JobTool;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.programcontrol.job.IJobTool;
import java.util.function.BooleanSupplier;

final class JobExecutor
extends Thread {
    private static final IJobTool JOB_TOOL = new JobTool();
    private final Runnable job;
    private int finishedJobCount;
    private boolean running = true;
    private final Integer maxRunCount;
    private final BooleanSupplier condition;
    private final Integer timeIntervalInMilliseconds;
    private Throwable error;

    public JobExecutor(Runnable job) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        this.job = job;
        this.maxRunCount = null;
        this.condition = null;
        this.timeIntervalInMilliseconds = null;
        this.start();
    }

    public JobExecutor(Runnable job, BooleanSupplier condition) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        Validator.assertThat(condition).thatIsNamed("condition").isNotNull();
        this.job = job;
        this.maxRunCount = null;
        this.condition = condition;
        this.timeIntervalInMilliseconds = null;
        this.start();
    }

    public JobExecutor(Runnable job, BooleanSupplier condition, int timeIntervalInMilliseconds) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        Validator.assertThat(condition).thatIsNamed("condition").isNotNull();
        Validator.assertThat(timeIntervalInMilliseconds).thatIsNamed("time interval in milliseoconds").isNotNegative();
        this.job = job;
        this.maxRunCount = null;
        this.condition = condition;
        this.timeIntervalInMilliseconds = timeIntervalInMilliseconds;
        this.start();
    }

    public JobExecutor(Runnable job, int maxRunCount) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        Validator.assertThat(maxRunCount).thatIsNamed("max run count").isNotNegative();
        this.job = job;
        this.maxRunCount = maxRunCount;
        this.condition = null;
        this.timeIntervalInMilliseconds = null;
        this.start();
    }

    public JobExecutor(Runnable job, int maxRunCount, BooleanSupplier condition) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        Validator.assertThat(maxRunCount).thatIsNamed("max run count").isNotNegative();
        Validator.assertThat(condition).thatIsNamed("condition").isNotNull();
        this.job = job;
        this.maxRunCount = maxRunCount;
        this.condition = condition;
        this.timeIntervalInMilliseconds = null;
        this.start();
    }

    public JobExecutor(Runnable job, int maxRunCount, BooleanSupplier condition, int timeIntervalInMilliseconds) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        Validator.assertThat(maxRunCount).thatIsNamed("max run count").isNotNegative();
        Validator.assertThat(condition).thatIsNamed("condition").isNotNull();
        Validator.assertThat(timeIntervalInMilliseconds).thatIsNamed("time interval in milliseconds").isNotNegative();
        this.job = job;
        this.maxRunCount = maxRunCount;
        this.condition = condition;
        this.timeIntervalInMilliseconds = timeIntervalInMilliseconds;
        this.start();
    }

    public JobExecutor(Runnable job, int maxRunCount, int timeIntervalInMilliseconds) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        Validator.assertThat(maxRunCount).thatIsNamed("max run count").isNotNegative();
        Validator.assertThat(timeIntervalInMilliseconds).thatIsNamed("time interval in milliseconds").isNotNegative();
        this.job = job;
        this.maxRunCount = maxRunCount;
        this.condition = null;
        this.timeIntervalInMilliseconds = timeIntervalInMilliseconds;
        this.start();
    }

    public static JobExecutor forJobs(IContainer<Runnable> jobs) {
        return new JobExecutor(JOB_TOOL.createConcatenatedJobFromJobs(jobs), 1);
    }

    public boolean caughtError() {
        return this.error != null;
    }

    public Throwable getError() {
        if (this.error == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "error");
        }
        return this.error;
    }

    public int getFinishedJobCount() {
        return this.finishedJobCount;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public boolean hasMaxRunCount() {
        return this.maxRunCount != null;
    }

    public boolean hasTimeInterval() {
        return this.timeIntervalInMilliseconds != null;
    }

    public boolean isFinished() {
        return !this.isRunning();
    }

    public boolean isFinishedSuccessfully() {
        return this.isFinished() && !this.caughtError();
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        while (this.runProbableNextStepAndSayIfRunningMustContinue()) {
        }
        this.running = false;
    }

    private boolean reachedProbableMaxRunCount() {
        return this.hasMaxRunCount() && this.finishedJobCount >= this.maxRunCount;
    }

    private boolean runProbableNextStepAndSayIfRunningMustContinue() {
        block5: {
            block4: {
                try {
                    if (!this.reachedProbableMaxRunCount()) break block4;
                    return false;
                }
                catch (Throwable paramError) {
                    this.error = paramError;
                    Logger.logError(paramError);
                    return false;
                }
            }
            this.waitForTimeIntervalIfHasTimeInterval();
            if (!this.violatesProbableCondition()) break block5;
            return false;
        }
        this.job.run();
        ++this.finishedJobCount;
        return true;
    }

    private boolean violatesProbableCondition() {
        return this.hasCondition() && !this.condition.getAsBoolean();
    }

    private void waitForTimeIntervalIfHasTimeInterval() {
        if (this.hasTimeInterval()) {
            Waiter.waitForMilliseconds(this.timeIntervalInMilliseconds);
        }
    }
}

