/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.AsLongAsMediator;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.coreapi.programcontrol.flowcontrol.IForMaxMillisecondsMediator;
import java.util.function.BooleanSupplier;

public final class ForMaxMillisecondsMediator
implements IForMaxMillisecondsMediator {
    private final int maxDurationInMilliseconds;

    private ForMaxMillisecondsMediator(int maxDurationInMilliseconds) {
        Validator.assertThat(maxDurationInMilliseconds).thatIsNamed("max duration in milliseconds").isNotNegative();
        this.maxDurationInMilliseconds = maxDurationInMilliseconds;
    }

    static ForMaxMillisecondsMediator forMaxMilliseconds(int maxDurationInMilliseconds) {
        return new ForMaxMillisecondsMediator(maxDurationInMilliseconds);
    }

    static ForMaxMillisecondsMediator forMaxSeconds(int maxDurationInSeconds) {
        Validator.assertThat(maxDurationInSeconds).thatIsNamed("max duration in seconds").isNotNegative();
        return new ForMaxMillisecondsMediator(maxDurationInSeconds * 1000);
    }

    @Override
    public AsLongAsMediator asLongAs(BooleanSupplier condition) {
        Validator.assertThat(condition).thatIsNamed("condition").isNotNull();
        long startTimeInMilliseconds = System.currentTimeMillis();
        long endTimeInMilliseconds = startTimeInMilliseconds + (long)this.maxDurationInMilliseconds;
        return AsLongAsMediator.withCondition(() -> System.currentTimeMillis() < endTimeInMilliseconds || condition.getAsBoolean());
    }

    @Override
    public AsLongAsMediator until(BooleanSupplier condition) {
        return this.asLongAs(() -> !condition.getAsBoolean());
    }

    @Override
    public void waitAsLongAs(BooleanSupplier condition) {
        long startTimeInMilliseconds = System.currentTimeMillis();
        long endTimeInMilliseconds = startTimeInMilliseconds + (long)this.maxDurationInMilliseconds;
        FlowController.waitAsLongAs(() -> System.currentTimeMillis() < endTimeInMilliseconds && condition.getAsBoolean());
    }

    @Override
    public void waitUntil(BooleanSupplier condition) {
        this.waitAsLongAs(() -> !condition.getAsBoolean());
    }
}

