/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.Future;
import ch.nolix.core.programcontrol.flowcontrol.JobExecutor;
import ch.nolix.coreapi.programcontrol.flowcontrol.IForCountMediator;
import ch.nolix.coreapi.programcontrol.future.IFuture;
import java.util.function.IntConsumer;

public final class ForCountMediator
implements IForCountMediator {
    private final int maxRunCount;

    private ForCountMediator(int maxRunCount) {
        Validator.assertThat(maxRunCount).thatIsNamed("max run count").isNotNegative();
        this.maxRunCount = maxRunCount;
    }

    public static ForCountMediator forMaxRunCount(int maxRunCount) {
        return new ForCountMediator(maxRunCount);
    }

    @Override
    public void run(Runnable job) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        int i = 1;
        while (i <= this.maxRunCount) {
            job.run();
            ++i;
        }
    }

    @Override
    public void run(IntConsumer job) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        int i = 1;
        while (i <= this.maxRunCount) {
            job.accept(i);
            ++i;
        }
    }

    @Override
    public IFuture runInBackground(Runnable job) {
        return Future.forJobExecturor(new JobExecutor(job, this.maxRunCount));
    }
}

