/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.AsLongAsMediator;
import ch.nolix.core.programcontrol.flowcontrol.AsSoonAsMediator;
import ch.nolix.core.programcontrol.flowcontrol.ForCountMediator;
import ch.nolix.core.programcontrol.flowcontrol.ForMaxMillisecondsMediator;
import ch.nolix.core.programcontrol.flowcontrol.Future;
import ch.nolix.core.programcontrol.flowcontrol.JobExecutor;
import ch.nolix.core.programcontrol.flowcontrol.ResultFuture;
import ch.nolix.core.programcontrol.flowcontrol.ResultJobExecutor;
import ch.nolix.core.programcontrol.flowcontrol.WaitMediator;
import ch.nolix.core.programcontrol.flowcontrol.Waiter;
import ch.nolix.core.programcontrol.jobpool.JobPool;
import ch.nolix.coreapi.programcontrol.flowcontrol.IAsLongAsMediator;
import ch.nolix.coreapi.programcontrol.flowcontrol.IAsSoonAsMediator;
import ch.nolix.coreapi.programcontrol.flowcontrol.IForCountMediator;
import ch.nolix.coreapi.programcontrol.flowcontrol.IForMaxMillisecondsMediator;
import ch.nolix.coreapi.programcontrol.flowcontrol.IWaitMediator;
import ch.nolix.coreapi.programcontrol.future.IFuture;
import ch.nolix.coreapi.programcontrol.future.IResultFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public final class FlowController {
    private static final JobPool JOB_POOL = new JobPool();

    private FlowController() {
    }

    public static IAsLongAsMediator asLongAs(BooleanSupplier condition) {
        return AsLongAsMediator.withCondition(condition);
    }

    public static IAsSoonAsMediator asSoonAs(BooleanSupplier condition) {
        return AsSoonAsMediator.withCondition(condition);
    }

    public static IAsSoonAsMediator asSoonAsNoMore(BooleanSupplier condition) {
        return AsSoonAsMediator.withCondition(() -> !condition.getAsBoolean());
    }

    public static IFuture enqueue(Runnable job) {
        return JOB_POOL.enqueue(job);
    }

    public static IForCountMediator forCount(int maxRunCount) {
        return ForCountMediator.forMaxRunCount(maxRunCount);
    }

    public static IForMaxMillisecondsMediator forMaxMilliseconds(int maxDurationInMilliseconds) {
        return ForMaxMillisecondsMediator.forMaxMilliseconds(maxDurationInMilliseconds);
    }

    public static IForMaxMillisecondsMediator forMaxSeconds(int maxDurationInSeconds) {
        return ForMaxMillisecondsMediator.forMaxSeconds(maxDurationInSeconds);
    }

    public static IFuture runInBackground(Runnable job) {
        return Future.forJobExecturor(new JobExecutor(job, 1));
    }

    public static IFuture runInBackgroundAndOrder(Runnable job, Runnable ... jobs) {
        ContainerView<Runnable> allJobes = ContainerView.forElementAndArray(job, jobs);
        return Future.forJobExecturor(JobExecutor.forJobs(allJobes));
    }

    public static <R> IResultFuture<R> runInBackground(Supplier<R> resultJob) {
        return new ResultFuture<R>(ResultJobExecutor.forResultJob(resultJob));
    }

    public static void runInEnclosedMode(Runnable job) {
        FlowController.runInEnclosedModeAndGetSuccessFlag(job);
    }

    public static boolean runInEnclosedModeAndGetSuccessFlag(Runnable job) {
        try {
            job.run();
            return true;
        }
        catch (Throwable error) {
            error.printStackTrace();
            return false;
        }
    }

    public static IAsLongAsMediator until(BooleanSupplier condition) {
        return AsLongAsMediator.withCondition(() -> !condition.getAsBoolean());
    }

    public static IWaitMediator waitAsLongAs(BooleanSupplier condition) {
        Validator.assertThat(condition).thatIsNamed("condition").isNotNull();
        int i = 1;
        while (condition.getAsBoolean()) {
            if (i < 100) {
                FlowController.waitForMilliseconds(10);
                ++i;
                continue;
            }
            FlowController.waitForMilliseconds(100);
        }
        return new WaitMediator();
    }

    public static IWaitMediator waitForMilliseconds(int durationInMilliseconds) {
        Waiter.waitForMilliseconds(durationInMilliseconds);
        return new WaitMediator();
    }

    public static IWaitMediator waitForSeconds(int durationInSeconds) {
        Waiter.waitForSeconds(durationInSeconds);
        return new WaitMediator();
    }

    public static IWaitMediator waitUntil(BooleanSupplier condition) {
        FlowController.waitAsLongAs(() -> !condition.getAsBoolean());
        return new WaitMediator();
    }
}

