/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.core.programcontrol.flowcontrol.Future;
import ch.nolix.core.programcontrol.flowcontrol.JobExecutor;
import ch.nolix.coreapi.programcontrol.flowcontrol.IAsSoonAsMediator;
import ch.nolix.coreapi.programcontrol.future.IFuture;
import java.util.function.BooleanSupplier;

public final class AsSoonAsMediator
implements IAsSoonAsMediator {
    private final BooleanSupplier condition;

    private AsSoonAsMediator(BooleanSupplier condition) {
        Validator.assertThat(condition).thatIsNamed("condition").isNotNull();
        this.condition = condition;
    }

    public static AsSoonAsMediator withCondition(BooleanSupplier condition) {
        return new AsSoonAsMediator(condition);
    }

    @Override
    public IFuture runInBackground(Runnable job) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        return Future.forJobExecturor(new JobExecutor(() -> this.runAsSoonAsConditionIsFulfilled(job), 1));
    }

    private void runAsSoonAsConditionIsFulfilled(Runnable job) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        FlowController.waitUntil(this.condition);
        job.run();
    }
}

