/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.websocket;

import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.validator.Validator;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public final class WebSocketHandShakeResponse {
    public static final String WEB_SOCKET_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final String SEC_WEBSOCKET_ACCEPT_HEADER = "Sec-WebSocket-Accept";
    public static final String SEC_WEBSOCKET_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    private final String secWebSocketKey;
    private final String secWebSocketAccept;

    public WebSocketHandShakeResponse(String secWebSocketKey) {
        Validator.assertThat(secWebSocketKey).thatIsNamed("sec web socket key").isNotNull();
        this.secWebSocketKey = secWebSocketKey;
        String secWebSocketKeyAndWebSocketGUID = secWebSocketKey + WEB_SOCKET_GUID;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = messageDigest.digest(secWebSocketKeyAndWebSocketGUID.getBytes(StandardCharsets.UTF_8));
            this.secWebSocketAccept = Base64.getEncoder().encodeToString(bytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw WrapperException.forError(noSuchAlgorithmException);
        }
    }

    public String getSecWebSocketAccept() {
        return this.secWebSocketAccept;
    }

    public String getSecWebSocketKey() {
        return this.secWebSocketKey;
    }

    public String toString() {
        return "HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Accept: " + this.secWebSocketAccept + "\r\n\r\n";
    }
}

