/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.websocket;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.net.websocket.WebSocketFramePayloadLengthType;
import java.math.BigInteger;

public record WebSocketFramePayloadLength(long value) {
    public WebSocketFramePayloadLength {
        Validator.assertThat(value).thatIsNamed("value").isNotNegative();
    }

    public WebSocketFramePayloadLengthType getType() {
        return WebSocketFramePayloadLengthType.fromPayloadLength(this.value);
    }

    public long getValue() {
        return this.value;
    }

    public byte[] toBytes() {
        return switch (this.getType()) {
            case WebSocketFramePayloadLengthType.BITS_7 -> this.toBytesWhen7Bits();
            case WebSocketFramePayloadLengthType.BITS_16 -> this.toBytesWhen16Bits();
            case WebSocketFramePayloadLengthType.BITS_64 -> this.toBytesWhen64Bits();
            default -> throw InvalidArgumentException.forArgument(this);
        };
    }

    private byte[] toBytesWhen7Bits() {
        byte[] byteArray = BigInteger.valueOf(this.value).toByteArray();
        return new byte[]{byteArray[0]};
    }

    private byte[] toBytesWhen16Bits() {
        byte[] byteArray = BigInteger.valueOf(this.value).toByteArray();
        if (byteArray.length == 1) {
            byte[] byArray = new byte[2];
            byArray[1] = byteArray[0];
            return byArray;
        }
        if (byteArray.length == 2) {
            return byteArray;
        }
        return new byte[]{byteArray[1], byteArray[2]};
    }

    private byte[] toBytesWhen64Bits() {
        byte[] byteArray = BigInteger.valueOf(this.value).toByteArray();
        byte[] result = new byte[8];
        int i = 0;
        while (i < byteArray.length) {
            result[result.length - byteArray.length + i] = byteArray[i];
            ++i;
        }
        return result;
    }
}

