/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.websocket;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.misc.dataobject.UnsignedByte;
import ch.nolix.coreapi.net.websocket.WebSocketFrameOpcodeMeaning;
import ch.nolix.coreapi.net.websocket.WebSocketFramePayloadLengthType;

final class WebSocketFrameFirstNibble {
    private final boolean mFINBit;
    private final int opcode;
    private final boolean maskBit;
    private final WebSocketFramePayloadLengthType payloadLengthSpecification;
    private final int m7BitPayloadLength;

    public WebSocketFrameFirstNibble(boolean mFINBit, WebSocketFrameOpcodeMeaning opcodeMeaning, boolean maskBit, int payloadLength) {
        Validator.assertThat(opcodeMeaning).thatIsNamed("opcode meaning").isNotNull();
        this.mFINBit = mFINBit;
        this.opcode = opcodeMeaning.toNumber();
        this.maskBit = maskBit;
        this.payloadLengthSpecification = WebSocketFramePayloadLengthType.fromPayloadLength(payloadLength);
        this.m7BitPayloadLength = this.payloadLengthSpecification == WebSocketFramePayloadLengthType.BITS_7 ? payloadLength : 0;
    }

    public WebSocketFrameFirstNibble(byte byte1, byte byte2) {
        UnsignedByte wrapperByte1 = new UnsignedByte(byte1);
        UnsignedByte wrapperByte2 = new UnsignedByte(byte2);
        boolean rsv1Bit = wrapperByte1.getBitAt(2);
        boolean rsv2Bit = wrapperByte1.getBitAt(3);
        boolean rsv3Bit = wrapperByte1.getBitAt(4);
        Validator.assertThatTheBit(rsv1Bit).thatIsNamed("RSV1Bit").isCleared();
        Validator.assertThatTheBit(rsv2Bit).thatIsNamed("RSV2Bit").isCleared();
        Validator.assertThatTheBit(rsv3Bit).thatIsNamed("RSV3Bit").isCleared();
        this.mFINBit = wrapperByte1.getBitAt(1);
        this.opcode = byte1 & 0xF;
        this.maskBit = wrapperByte2.getBitAt(1);
        this.payloadLengthSpecification = WebSocketFramePayloadLengthType.fromCode(byte2 & 0x7F);
        this.m7BitPayloadLength = byte2 & 0x7F;
    }

    public static WebSocketFrameFirstNibble fromNibble(byte[] nibble) {
        Validator.assertThat(nibble).hasElementCount(2);
        return new WebSocketFrameFirstNibble(nibble[0], nibble[1]);
    }

    public int get7BitsPayloadLength() {
        return this.m7BitPayloadLength;
    }

    public byte getByte1() {
        int byte1 = 0;
        if (this.getFINBit()) {
            byte1 |= 0x80;
        }
        return (byte)(byte1 |= this.opcode);
    }

    public byte getByte2() {
        int byte2 = 0;
        if (this.getMaskBit()) {
            byte2 |= 0x40;
        }
        WebSocketFramePayloadLengthType payloadLengthType = this.getPayloadLengthType();
        switch (payloadLengthType) {
            case BITS_7: {
                byte2 |= this.m7BitPayloadLength;
                break;
            }
            case BITS_16: {
                byte2 |= 0x7E;
                break;
            }
            case BITS_64: {
                byte2 |= 0x7F;
                break;
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)payloadLengthType);
            }
        }
        return (byte)byte2;
    }

    public boolean getFINBit() {
        return this.mFINBit;
    }

    public boolean getMaskBit() {
        return this.maskBit;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public WebSocketFrameOpcodeMeaning getOpcodeMeaning() {
        return WebSocketFrameOpcodeMeaning.fromNumber(this.opcode);
    }

    public WebSocketFramePayloadLengthType getPayloadLengthType() {
        return this.payloadLengthSpecification;
    }

    public byte[] toBytes() {
        return new byte[]{this.getByte1(), this.getByte2()};
    }
}

