/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint.AbstractNetEndPoint;
import ch.nolix.core.net.endpoint.WebEndPointMessageListener;
import ch.nolix.core.net.websocket.WebSocketFrame;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.coreapi.net.endpointprotocol.MessageType;
import ch.nolix.coreapi.net.netproperty.ConnectionType;
import ch.nolix.coreapi.net.netproperty.PeerType;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;
import ch.nolix.coreapi.net.websocket.WebSocketFrameOpcodeMeaning;
import ch.nolix.coreapi.programcontrol.processproperty.TargetInfoState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

final class WebSocketEndPoint
extends AbstractNetEndPoint {
    private static final int CONNECT_TIMEOUT_IN_MILLISECONDS = 500;
    private final PeerType peerType;
    private final Socket socket;
    private final InputStream socketInputStream;
    private final OutputStream socketOutputStream;

    public WebSocketEndPoint(Socket socket, InputStream socketInputStream, OutputStream socketOutputStream) {
        super(TargetInfoState.WAITS_TO_TARGET_INFO);
        Validator.assertThat(socket).thatIsNamed(Socket.class).isNotNull();
        Validator.assertThat(socketInputStream).thatIsNamed("socket input stream").isNotNull();
        Validator.assertThat(socketOutputStream).thatIsNamed("socket output stream").isNotNull();
        this.peerType = PeerType.BACKEND;
        this.socket = socket;
        this.socketInputStream = socketInputStream;
        this.socketOutputStream = socketOutputStream;
        this.createMessageListenerAndWaitToTargetInfo();
    }

    @Override
    public PeerType getPeerType() {
        return this.peerType;
    }

    @Override
    public SecurityMode getSecurityMode() {
        return SecurityMode.NONE;
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.WEB_SOCKET;
    }

    @Override
    public void noteClose() {
        if (this.canWork()) {
            this.sendRawMessage(MessageType.CLOSE_MESSAGE.getPrefix());
        }
        try {
            this.socket.close();
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    @Override
    protected void sendRawMessage(String rawMessage) {
        this.sendFrame(new WebSocketFrame(true, WebSocketFrameOpcodeMeaning.TEXT_FRAME, false, rawMessage));
    }

    InputStream getStoredInputStream() {
        return this.socketInputStream;
    }

    void receiveControlFrame(WebSocketFrame controlFrame) {
        switch (controlFrame.getOpcodeMeaning()) {
            case PING: {
                this.sendPongFrameForPingFrame(controlFrame);
                break;
            }
            case CONNECTION_CLOSE: {
                this.close();
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName(controlFrame, "control frame");
            }
        }
    }

    private boolean canWork() {
        return !this.socket.isClosed();
    }

    private void createMessageListenerAndWaitToTargetInfo() {
        WebEndPointMessageListener.forWebEndPoint(this);
        this.waitToTargetInfo();
    }

    private void sendBytes(byte[] bytes) {
        this.assertIsOpen();
        try {
            this.socketOutputStream.write(bytes);
            this.socketOutputStream.flush();
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    private void sendFrame(WebSocketFrame frame) {
        this.sendBytes(frame.toBytes());
    }

    private void sendPongFrameForPingFrame(WebSocketFrame pingFrame) {
        this.sendFrame(pingFrame.createPongFrame());
    }

    private void waitToTargetInfo() {
        FlowController.forMaxMilliseconds(500).waitUntil(this::hasTargetInfo);
        if (!this.hasTargetInfo()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "reached timeout while waiting to target");
        }
    }
}

