/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.environment.filesystem.FileSystemAccessor;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.net.ssl.SslCertificateKeyReader;
import ch.nolix.coreapi.net.ssl.ISslCertificate;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

final class SslServerSslContextCreator {
    private static final String PASSWORD = "my_password";
    private static final char[] PASSWORD_AS_CHAR_ARRAY = "my_password".toCharArray();
    private static final SslCertificateKeyReader SSL_CERTIFICATE_KEY_READER = new SslCertificateKeyReader();

    SslServerSslContextCreator() {
    }

    public SslContext createSSLContext(ISslCertificate paramSSLCertificate) {
        try {
            X509Certificate cert = this.getCert(paramSSLCertificate);
            PrivateKey key = this.getPrivateKey(paramSSLCertificate);
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(null, PASSWORD_AS_CHAR_ARRAY);
            keystore.setCertificateEntry("cert-alias", cert);
            keystore.setKeyEntry("key-alias", key, PASSWORD_AS_CHAR_ARRAY, new Certificate[]{cert});
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, PASSWORD_AS_CHAR_ARRAY);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory);
            return sslContextBuilder.build();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException | InvalidKeySpecException exception) {
            throw WrapperException.forError(exception);
        }
    }

    private X509Certificate getCert(ISslCertificate paramSSLCertificate) throws CertificateException {
        String filePath = paramSSLCertificate.getPublicKeyPemFilePath();
        return (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(FileSystemAccessor.readFileToBytes(filePath)));
    }

    private PrivateKey getPrivateKey(ISslCertificate paramSSLCertificate) throws InvalidKeySpecException, NoSuchAlgorithmException {
        String privateKeyPemFilePath = paramSSLCertificate.getPrivateKeyPemFilePath();
        String privateKey = SSL_CERTIFICATE_KEY_READER.readKeyFromPemFile(privateKeyPemFilePath);
        byte[] privateKeyAsBytes = Base64.getDecoder().decode(privateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyAsBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        return keyFactory.generatePrivate(keySpec);
    }
}

