/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;

final class SslServerIndexPageHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final String htmlPage;

    public SslServerIndexPageHandler(String htmlPage) {
        this.htmlPage = htmlPage;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        if (!req.decoderResult().isSuccess()) {
            SslServerIndexPageHandler.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST, ctx.alloc().buffer(0)));
            return;
        }
        if (!HttpMethod.GET.equals((Object)req.method())) {
            SslServerIndexPageHandler.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.FORBIDDEN, ctx.alloc().buffer(0)));
            return;
        }
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)this.htmlPage, (Charset)CharsetUtil.US_ASCII);
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, content);
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
        HttpUtil.setContentLength((HttpMessage)res, (long)content.readableBytes());
        SslServerIndexPageHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        HttpResponseStatus responseStatus = res.status();
        if (responseStatus.code() != 200) {
            ByteBufUtil.writeUtf8((ByteBuf)res.content(), (CharSequence)responseStatus.toString());
            HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        }
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req) && responseStatus.code() == 200;
        HttpUtil.setKeepAlive((HttpMessage)res, (boolean)keepAlive);
        ChannelFuture future = ctx.writeAndFlush((Object)res);
        if (!keepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

