/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint.SslServer;
import ch.nolix.core.net.endpoint.SslServerEndPoint;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;

final class SslServerChannelInboundHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private final SslServer parentWebSocketServer;
    private SslServerEndPoint parentWebSocketServerEndPoint;

    public SslServerChannelInboundHandler(SslServer parentWebSocketServer) {
        Validator.assertThat(parentWebSocketServer).thatIsNamed("parent web-socket server").isNotNull();
        this.parentWebSocketServer = parentWebSocketServer;
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.parentWebSocketServerEndPoint.close();
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame) throws Exception {
        if (this.parentWebSocketServerEndPoint == null) {
            this.parentWebSocketServerEndPoint = new SslServerEndPoint(channelHandlerContext);
            String rawMessage = ((TextWebSocketFrame)webSocketFrame).text();
            this.parentWebSocketServerEndPoint.receiveRawMessage(rawMessage);
            this.parentWebSocketServer.internalTakeBackendEndPoint(this.parentWebSocketServerEndPoint);
        } else if (webSocketFrame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)webSocketFrame;
            String rawMessage = textWebSocketFrame.text();
            this.parentWebSocketServerEndPoint.receiveRawMessageInBackground(rawMessage);
        } else {
            throw InvalidArgumentException.forArgument(webSocketFrame);
        }
    }
}

