/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.commontypetool.inputstreamtool.InputStreamTool;
import ch.nolix.core.commontypetool.stringtool.StringTool;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.logging.Logger;
import ch.nolix.core.net.endpoint.Server;
import ch.nolix.core.net.endpoint.SocketEndPoint;
import ch.nolix.core.net.endpoint.WebSocketEndPoint;
import ch.nolix.core.net.http.HttpRequest;
import ch.nolix.core.net.websocket.WebSocketHandShakeRequest;
import ch.nolix.coreapi.commontypetool.inputstreamtool.IInputStreamTool;
import ch.nolix.coreapi.net.endpoint.IEndPoint;
import ch.nolix.coreapi.net.endpoint.SocketType;
import ch.nolix.coreapi.net.endpointprotocol.MessageType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public final class SocketHandler {
    private static final IInputStreamTool INPUT_STREAM_TOOL = new InputStreamTool();

    private SocketHandler() {
    }

    public static void handleSocketForServer(Socket socket, Server server) {
        Optional<IEndPoint> backendNetEndPoint = SocketHandler.createOptionalBackendNetEndPointForSocketAndServer(socket, server);
        if (backendNetEndPoint.isEmpty()) {
            SocketHandler.closeSocket(socket);
        } else {
            server.internalTakeBackendEndPoint(backendNetEndPoint.get());
        }
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException ioException) {
            throw WrapperException.forError(ioException);
        }
    }

    private static Optional<IEndPoint> createOptionalBackendNetEndPointForSocketAndServer(Socket socket, InputStream socketInputStream, OutputStream socketOutputStream, String firstReveivedLine, SocketType socketType, Server server) {
        return switch (socketType) {
            case SocketType.NET_SOCKET_WITH_DEFAULT_TARGET -> Optional.of(SocketHandler.createSocketEndPointWithDefaultTarget(socket, socketInputStream, socketOutputStream));
            case SocketType.NET_SOCKET_WITH_CUSTOM_TARGET -> Optional.of(SocketHandler.createSocketEndPointWithCustomTarget(socket, socketInputStream, socketOutputStream, firstReveivedLine));
            case SocketType.HTTP_SOCKET_OR_WEB_SOCKET -> SocketHandler.createOptionalBackendNetEndPointForSocketAndServerWhenIsHttpSocketOrWebSocket(socket, socketInputStream, socketOutputStream, firstReveivedLine, server);
            default -> throw new MatchException(null, null);
        };
    }

    private static Optional<IEndPoint> createOptionalBackendNetEndPointForSocketAndServer(Socket socket, Server server) {
        Optional<InputStream> socketInputStream = SocketHandler.getOptionalInputStreamOfSocket(socket);
        Optional<OutputStream> socketOutputStream = SocketHandler.getOptionalOutputStreamOfSocket(socket);
        if (socketInputStream.isEmpty() || socketOutputStream.isEmpty()) {
            return Optional.empty();
        }
        String firstReveivedLine = INPUT_STREAM_TOOL.readLineFromInputStreamOrNull(socketInputStream.get());
        Logger.logInfo("The current SocketHandler received the first line from the given socket: " + StringTool.getInSingleQuotes(firstReveivedLine));
        Optional<SocketType> socketType = SocketHandler.getSocketTypeFromFirstReceivedLine(firstReveivedLine);
        if (socketType.isEmpty()) {
            return Optional.empty();
        }
        return SocketHandler.createOptionalBackendNetEndPointForSocketAndServer(socket, socketInputStream.get(), socketOutputStream.get(), firstReveivedLine, socketType.get(), server);
    }

    private static Optional<IEndPoint> createOptionalBackendNetEndPointForSocketAndServerWhenIsHttpSocketOrWebSocket(Socket socket, InputStream socketInputStream, OutputStream socketOutputStream, String firstReveivedLine, Server server) {
        LinkedList<String> lines = LinkedList.withElement(firstReveivedLine, new String[0]);
        SocketHandler.fillUpLinesIntoListUntilReceivesEmptyLine(lines, socketInputStream);
        if (WebSocketHandShakeRequest.canBe(lines)) {
            Logger.logInfo("The current SocketHandler has received the web socket opening handshake request: " + StringTool.getInSingleQuotes(lines.toString()));
            String openingHandshakeResponse = new WebSocketHandShakeRequest(lines).getWebSocketHandShakeResponse().toString();
            Logger.logInfo("The current SocketHandler sends the opening handshake response: " + StringTool.getInSingleQuotes(openingHandshakeResponse));
            SocketHandler.sendRawMessageToOutputStream(socketOutputStream, openingHandshakeResponse);
            return Optional.of(new WebSocketEndPoint(socket, socketInputStream, socketOutputStream));
        }
        if (HttpRequest.canBe(lines)) {
            SocketHandler.sendRawMessageToOutputStream(socketOutputStream, server.getInitialHttpMessage());
        }
        return Optional.empty();
    }

    private static SocketEndPoint createSocketEndPointWithCustomTarget(Socket socket, InputStream socketInputStream, OutputStream socketOutputStream, String firstReveivedLine) {
        return new SocketEndPoint(socket, socketInputStream, socketOutputStream, Node.fromString(firstReveivedLine.substring(1)).getHeader());
    }

    private static SocketEndPoint createSocketEndPointWithDefaultTarget(Socket socket, InputStream socketInputStream, OutputStream socketOutputStream) {
        return new SocketEndPoint(socket, socketInputStream, socketOutputStream);
    }

    private static void fillUpLinesIntoListUntilReceivesEmptyLine(LinkedList<String> lines, InputStream inputStream) {
        while (true) {
            String line;
            if ((line = INPUT_STREAM_TOOL.readLineFromInputStreamOrNull(inputStream)) == null) {
                throw ArgumentIsNullException.forArgumentName("line");
            }
            if (line.isEmpty()) break;
            lines.addAtEnd(line);
        }
    }

    private static Optional<InputStream> getOptionalInputStreamOfSocket(Socket socket) {
        try {
            return Optional.of(socket.getInputStream());
        }
        catch (IOException ioException) {
            Logger.logError(ioException);
            return Optional.empty();
        }
    }

    private static Optional<OutputStream> getOptionalOutputStreamOfSocket(Socket socket) {
        try {
            return Optional.of(socket.getOutputStream());
        }
        catch (IOException ioException) {
            Logger.logError(ioException);
            return Optional.empty();
        }
    }

    private static Optional<SocketType> getSocketTypeFromFirstReceivedLine(String firstReceivedLine) {
        if (firstReceivedLine.equals(MessageType.DEFAULT_TARGET_MESSAGE.getPrefix())) {
            return Optional.of(SocketType.NET_SOCKET_WITH_DEFAULT_TARGET);
        }
        if (firstReceivedLine.startsWith(MessageType.TARGET_MESSAGE.getPrefix())) {
            return Optional.of(SocketType.NET_SOCKET_WITH_CUSTOM_TARGET);
        }
        if (firstReceivedLine.startsWith("G")) {
            return Optional.of(SocketType.HTTP_SOCKET_OR_WEB_SOCKET);
        }
        return Optional.empty();
    }

    private static void sendRawMessageToOutputStream(OutputStream outputStream, String rawMessage) {
        try {
            outputStream.write(rawMessage.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }
        catch (IOException ioException) {
            throw WrapperException.forError(ioException);
        }
    }
}

