/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint.AbstractEndPoint;
import ch.nolix.core.net.endpoint.AbstractServer;
import ch.nolix.coreapi.net.endpoint.ISlot;
import ch.nolix.coreapi.net.netproperty.ConnectionType;
import ch.nolix.coreapi.net.netproperty.PeerType;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;

public final class LocalEndPoint
extends AbstractEndPoint {
    private final PeerType peerType;
    private final LocalEndPoint counterpart;

    private LocalEndPoint(AbstractServer server, String slot) {
        this.peerType = PeerType.FRONTEND;
        this.setCustomTargetSlot(slot);
        this.counterpart = new LocalEndPoint(this);
        this.getStoredCounterPart().setCustomTargetSlot(slot);
        server.internalTakeBackendEndPoint(this.getStoredCounterPart());
    }

    private LocalEndPoint(ISlot slot) {
        Validator.assertThat(slot).thatIsNamed(ISlot.class).isNotNull();
        this.peerType = PeerType.FRONTEND;
        this.counterpart = new LocalEndPoint(this);
        this.getStoredCounterPart().setCustomTargetSlot(slot.getName());
        slot.takeBackendEndPoint(this.getStoredCounterPart());
    }

    private LocalEndPoint(LocalEndPoint counterpart) {
        this.peerType = PeerType.BACKEND;
        Validator.assertThat(counterpart).thatIsNamed("counterpart").isNotNull();
        this.createCloseDependencyTo(counterpart);
        this.counterpart = counterpart;
    }

    public static LocalEndPoint toSlot(ISlot slot) {
        return new LocalEndPoint(slot);
    }

    public static LocalEndPoint toTargetSlotOnServer(AbstractServer server, String targetSlot) {
        return new LocalEndPoint(server, targetSlot);
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.LOCAL;
    }

    @Override
    public PeerType getPeerType() {
        return this.peerType;
    }

    @Override
    public SecurityMode getSecurityMode() {
        return SecurityMode.NONE;
    }

    @Override
    public void noteClose() {
    }

    @Override
    public void sendMessage(String message) {
        Validator.assertThat(message).thatIsNamed("message").isNotNull();
        this.assertIsOpen();
        this.counterpart.receiveMessage(message);
    }

    private LocalEndPoint getStoredCounterPart() {
        return this.counterpart;
    }

    private void receiveMessage(String message) {
        this.getStoredReceiver().accept(message);
    }
}

