/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.core.resourcecontrol.resourcevalidator.ResourceValidator;
import ch.nolix.coreapi.net.endpoint.IEndPoint;
import ch.nolix.coreapi.net.endpoint.IServer;
import ch.nolix.coreapi.net.endpoint.ISlot;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;

public abstract class AbstractServer
implements IServer {
    private final ICloseController closeController = CloseController.forElement(this);
    private ISlot memberDefaultSlot;
    private final LinkedList<ISlot> slots = LinkedList.createEmpty();

    @Override
    public final void addDefaultSlot(ISlot defaultSlot) {
        this.addSlot(defaultSlot);
        this.memberDefaultSlot = defaultSlot;
    }

    @Override
    public final void addSlot(ISlot slot) {
        this.assertDoesNotContainSlotWithName(slot.getName());
        this.slots.addAtEnd(slot);
    }

    @Override
    public final void clear() {
        this.slots.clear();
        this.memberDefaultSlot = null;
    }

    @Override
    public final boolean containsDefaultSlot() {
        return this.memberDefaultSlot != null;
    }

    @Override
    public final boolean containsSlotWithName(String name) {
        return this.slots.containsAny(s -> s.hasName(name));
    }

    @Override
    public final ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public final boolean isEmpty() {
        return this.slots.isEmpty();
    }

    @Override
    public final void removeSlotByName(String name) {
        this.removeSlot(this.slots.getStoredFirst(s -> s.hasName(name)));
    }

    final void internalTakeBackendEndPoint(IEndPoint endPoint) {
        ResourceValidator.assertIsOpen(endPoint);
        if (!endPoint.hasCustomTargetSlot()) {
            this.getStoredDefaultSlot().takeBackendEndPoint(endPoint);
        } else {
            this.getStoredSlotName(endPoint.getCustomTargetSlot()).takeBackendEndPoint(endPoint);
        }
    }

    private void assertContainsDefaultSlot() {
        if (!this.containsDefaultSlot()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "default end point taker");
        }
    }

    private void assertDoesNotContainSlotWithName(String name) {
        if (this.containsSlotWithName(name)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "contains already a slot with the name '" + name + "'");
        }
    }

    private ISlot getStoredDefaultSlot() {
        this.assertContainsDefaultSlot();
        return this.memberDefaultSlot;
    }

    private ISlot getStoredSlotName(String name) {
        return this.slots.getStoredFirst(ept -> ept.hasName(name));
    }

    private void removeSlot(ISlot slot) {
        this.slots.removeStrictlyFirstOccurrenceOf(slot);
        if (slot == this.memberDefaultSlot) {
            this.memberDefaultSlot = null;
        }
    }
}

