/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.misc.dataobject;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.misc.dataobject.IBlob;
import java.nio.charset.StandardCharsets;

public final class Blob
implements IBlob {
    private final byte[] bytes;

    private Blob(byte[] bytes) {
        Validator.assertThat(bytes).thatIsNamed("bytes").isNotNull();
        this.bytes = bytes;
    }

    public static Blob forBytes(byte[] bytes) {
        return new Blob(bytes);
    }

    public static Blob fromString(String string) {
        return new Blob(string.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] getStoredBytes() {
        return this.bytes;
    }

    @Override
    public int getSize() {
        return this.bytes.length;
    }

    public String toString() {
        return new String(this.bytes, StandardCharsets.UTF_8);
    }
}

