/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.math.stochastic;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.validator.Validator;

public abstract class AbstractStatisticalModel {
    private final int backStepCount;
    private final double[] inputValues;
    private final LinkedList<Double> forecasts = LinkedList.createEmpty();

    protected AbstractStatisticalModel(int backStepsCount, double[] inputValues) {
        Validator.assertThat(inputValues).thatIsNamed("input values").isNotEmpty();
        Validator.assertThat(backStepsCount).thatIsNamed("back step count").isBetween(1, inputValues.length);
        this.backStepCount = backStepsCount;
        this.inputValues = (double[])inputValues.clone();
    }

    public final int getBackStepsCount() {
        return this.backStepCount;
    }

    public final int getInputValuesCount() {
        return this.inputValues.length;
    }

    public final double getForecast(int index) {
        Validator.assertThat(index).thatIsNamed("index").isPositive();
        while (this.forecasts.getCount() < index) {
            this.forecasts.addAtEnd(this.calculateNextValue());
        }
        return this.forecasts.getStoredAtOneBasedIndex(index);
    }

    protected abstract double calculateNextValue();

    protected final int getIndexOfNextValue() {
        return this.getInputValuesCount() + this.forecasts.getCount() + 1;
    }

    protected final double getValueFromBack(int index) {
        Validator.assertThat(index).thatIsNamed("index").isPositive();
        Validator.assertThat(index).thatIsNamed("index").isNotBiggerThan(this.inputValues.length + this.forecasts.getCount());
        if (index > this.forecasts.getCount()) {
            return this.inputValues[this.getInputValuesCount() + this.forecasts.getCount() - index];
        }
        return this.forecasts.getStoredAtOneBasedIndex(this.forecasts.getCount() - index + 1);
    }
}

