/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.math.stochastic;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.math.algebra.Matrix;
import ch.nolix.core.math.stochastic.AbstractStatisticalModel;

public final class ARModel
extends AbstractStatisticalModel {
    private final double constant;
    private final double[] pCoefficients;

    public ARModel(int pOrder, double[] inputValues) {
        super(pOrder, inputValues);
        Matrix factor1Matrix = Matrix.withRowCountAndColumnCount(inputValues.length - pOrder, pOrder + 1);
        int i = 1;
        while (i <= factor1Matrix.getRowCount()) {
            int j = 1;
            while (j < factor1Matrix.getColumnCount()) {
                factor1Matrix.setValue(i, j, inputValues[i + factor1Matrix.getColumnCount() - j - 2]);
                ++j;
            }
            factor1Matrix.setValue(i, factor1Matrix.getColumnCount(), 1.0);
            ++i;
        }
        Matrix productMatrix = Matrix.withRowCountAndColumnCount(inputValues.length - pOrder, 1);
        int i2 = pOrder;
        while (i2 < inputValues.length) {
            productMatrix.setValue(i2 - pOrder + 1, 1, inputValues[i2]);
            ++i2;
        }
        Matrix factor2Matrix = factor1Matrix.getMinimalFactorMatrix(productMatrix);
        this.pCoefficients = new double[pOrder];
        int i3 = 0;
        while (i3 < pOrder) {
            this.pCoefficients[i3] = factor2Matrix.getValue(i3 + 1, 1);
            ++i3;
        }
        this.constant = factor2Matrix.getValue(factor2Matrix.getSize(), 1);
    }

    public double getConstant() {
        return this.constant;
    }

    public double getPCoefficient(int index) {
        Validator.assertThat(index).thatIsNamed("index").isBetween(1, this.getPOrder());
        return this.pCoefficients[index - 1];
    }

    public int getPOrder() {
        return this.pCoefficients.length;
    }

    @Override
    protected double calculateNextValue() {
        double nextValue = this.constant;
        int i = 0;
        while (i < this.getPOrder()) {
            nextValue += this.pCoefficients[i] * this.getValueFromBack(i + 1);
            ++i;
        }
        return nextValue;
    }
}

