/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.math.main;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.math.algebra.Matrix;
import ch.nolix.core.math.algebra.Polynom;
import ch.nolix.core.math.basic.BasicCalculator;
import ch.nolix.core.math.stochastic.ARModel;

public final class Calculator {
    private static final BasicCalculator BASIC_CALCULATOR = new BasicCalculator();

    private Calculator() {
    }

    public static double getAbsoluteDifference(double value1, double value2) {
        return BASIC_CALCULATOR.getAbsoluteDifference(value2, value1);
    }

    public static int getAbsoluteDifference(int value1, int value2) {
        return BASIC_CALCULATOR.getAbsoluteDifference(value2, value1);
    }

    public static long getAbsoluteDifference(long value1, long value2) {
        return BASIC_CALCULATOR.getAbsoluteDifference(value2, value1);
    }

    public static double getAbsoluteValue(double value) {
        return BASIC_CALCULATOR.getAbsoluteValue(value);
    }

    public static int getAbsoluteValue(int value) {
        return BASIC_CALCULATOR.getAbsoluteValue(value);
    }

    public static long getAbsoluteValue(long value) {
        return BASIC_CALCULATOR.getAbsoluteValue(value);
    }

    public static double getAverage(double value, double ... values) {
        return BASIC_CALCULATOR.getAverage(value, values);
    }

    public static double getAverage(Iterable<Double> values) {
        return BASIC_CALCULATOR.getAverage(values);
    }

    public static int getAverage(int value, int ... values) {
        return BASIC_CALCULATOR.getAverage(value, values);
    }

    public static long getAverage(long value, long ... values) {
        return BASIC_CALCULATOR.getAverage(value, values);
    }

    public static ARModel getARModell(int pOrder, double[] inputValues) {
        return new ARModel(pOrder, inputValues);
    }

    public static Polynom getFittingPolynom(int degree, double[] xValues, double[] yValues) {
        Validator.assertThat(degree).thatIsNamed("degree").isNotNegative();
        Validator.assertThat(degree).thatIsNamed("degree").isNotBiggerThan(xValues.length);
        Validator.assertThat(yValues).thatIsNamed("y-values container").hasSameSizeAs(xValues);
        Matrix factorMatrix = Matrix.withRowCountAndColumnCount(xValues.length, degree + 1);
        double[] xMatrixValues = new double[factorMatrix.getSize()];
        int i = 0;
        while (i < factorMatrix.getRowCount()) {
            int j = 0;
            while (j < factorMatrix.getColumnCount()) {
                xMatrixValues[i * factorMatrix.getColumnCount() + j] = Math.pow(xValues[i], (double)(factorMatrix.getColumnCount() - j) - 1.0);
                ++j;
            }
            ++i;
        }
        factorMatrix.setValues(xMatrixValues);
        Matrix solutionMatrix = Matrix.withRowCountAndColumnCount(yValues.length, 1);
        solutionMatrix.setValues(yValues);
        return factorMatrix.getMinimalFactorMatrix(solutionMatrix).toPolynom();
    }

    public static double getMax(double value, double ... values) {
        return BASIC_CALCULATOR.getMax(value, values);
    }

    public static int getMax(int value, int ... values) {
        return BASIC_CALCULATOR.getMax(value, values);
    }

    public static long getMax(long value, long ... values) {
        return BASIC_CALCULATOR.getMax(value, values);
    }

    public static double getMin(double value, double ... values) {
        return BASIC_CALCULATOR.getMin(value, values);
    }

    public static int getMin(int value, int ... values) {
        return BASIC_CALCULATOR.getMin(value, values);
    }

    public static long getMin(long value, long ... values) {
        return BASIC_CALCULATOR.getMin(value, values);
    }

    public static double getSquare(double value) {
        return BASIC_CALCULATOR.getSquare(value);
    }

    public static double getSquare(int value) {
        return BASIC_CALCULATOR.getSquare(value);
    }

    public static double getSquare(long value) {
        return BASIC_CALCULATOR.getSquare(value);
    }

    public static double getSum(double value, double ... values) {
        return BASIC_CALCULATOR.getSum(value, values);
    }

    public static int getSum(int value, int ... values) {
        return BASIC_CALCULATOR.getSum(value, values);
    }

    public static double getSum(Iterable<Double> values) {
        return BASIC_CALCULATOR.getSum(values);
    }

    public static long getSum(long value, long ... values) {
        return BASIC_CALCULATOR.getSum(value, values);
    }
}

