/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.math.basic;

import ch.nolix.core.errorcontrol.invalidargumentexception.EmptyArgumentException;
import ch.nolix.coreapi.math.basic.IBasicCalculator;

public final class BasicCalculator
implements IBasicCalculator {
    @Override
    public double getAbsoluteDifference(double value1, double value2) {
        return this.getAbsoluteValue(value2 - value1);
    }

    @Override
    public int getAbsoluteDifference(int value1, int value2) {
        return this.getAbsoluteValue(value2 - value1);
    }

    @Override
    public long getAbsoluteDifference(long value1, long value2) {
        return this.getAbsoluteValue(value2 - value1);
    }

    @Override
    public double getAbsoluteValue(double value) {
        if (value < 0.0) {
            return -value;
        }
        return value;
    }

    @Override
    public int getAbsoluteValue(int value) {
        if (value < 0) {
            return -value;
        }
        return value;
    }

    @Override
    public long getAbsoluteValue(long value) {
        if (value < 0L) {
            return -value;
        }
        return value;
    }

    @Override
    public double getAverage(double value, double ... values) {
        double sum = this.getSum(value, values);
        int valueCount = 1 + values.length;
        return sum / (double)valueCount;
    }

    @Override
    public double getAverage(Iterable<Double> values) {
        int count = 0;
        double sum = 0.0;
        for (Double v : values) {
            ++count;
            sum += v.doubleValue();
        }
        if (count == 0) {
            throw EmptyArgumentException.forArgumentAndArgumentName(values, "values");
        }
        return sum / (double)count;
    }

    @Override
    public int getAverage(int value, int ... values) {
        int sum = this.getSum(value, values);
        int valueCount = 1 + values.length;
        return sum / valueCount;
    }

    @Override
    public long getAverage(long value, long ... values) {
        long sum = this.getSum(value, values);
        int valueCount = 1 + values.length;
        return sum / (long)valueCount;
    }

    @Override
    public double getMax(double value, double ... values) {
        double max = value;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (v > max) {
                max = v;
            }
            ++n2;
        }
        return max;
    }

    @Override
    public int getMax(int value, int ... values) {
        int max = value;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (v > max) {
                max = v;
            }
            ++n2;
        }
        return max;
    }

    @Override
    public long getMax(long value, long ... values) {
        long max = value;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            if (v > max) {
                max = v;
            }
            ++n2;
        }
        return max;
    }

    @Override
    public double getMin(double value, double ... values) {
        double min = value;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (v < min) {
                min = v;
            }
            ++n2;
        }
        return min;
    }

    @Override
    public int getMin(int value, int ... values) {
        int min = value;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (v < min) {
                min = v;
            }
            ++n2;
        }
        return min;
    }

    @Override
    public long getMin(long value, long ... values) {
        long min = value;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            if (v < min) {
                min = v;
            }
            ++n2;
        }
        return min;
    }

    @Override
    public double getSquare(double value) {
        return value * value;
    }

    @Override
    public double getSquare(int value) {
        return value * value;
    }

    @Override
    public double getSquare(long value) {
        return value * value;
    }

    @Override
    public double getSum(double value, double ... values) {
        double sum = value;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            sum += v;
            ++n2;
        }
        return sum;
    }

    @Override
    public int getSum(int value, int ... values) {
        int sum = value;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            sum += v;
            ++n2;
        }
        return sum;
    }

    @Override
    public double getSum(Iterable<Double> values) {
        double sum = 0.0;
        for (Double v : values) {
            sum += v.doubleValue();
        }
        return sum;
    }

    @Override
    public long getSum(long value, long ... values) {
        long sum = value;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            sum += v;
            ++n2;
        }
        return sum;
    }
}

