/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.math.algebra;

import ch.nolix.core.commontypetool.arraytool.ArrayTool;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.independent.math.NumberComparator;
import java.util.Arrays;

public final class Vector {
    public static final Vector EMPTY_VECTOR = new Vector();
    private static final ArrayTool ARRAY_TOOL = new ArrayTool();
    private final double[] values;

    private Vector() {
        this.values = new double[0];
    }

    private Vector(double[] values) {
        this.values = Arrays.copyOf(values, values.length);
    }

    public static Vector fromArray(double[] values) {
        return new Vector(values);
    }

    public static Vector withValue(double value, double ... values) {
        return new Vector(ARRAY_TOOL.createArrayWithValue(value, values));
    }

    public static Vector withValues(double[] values) {
        return new Vector(values);
    }

    public boolean equals(Object object) {
        Vector vector;
        return object instanceof Vector && this.equalsVector(vector = (Vector)object);
    }

    public double getEuclidNorm() {
        double sum = 0.0;
        double[] dArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            sum += Math.pow(v, 2.0);
            ++n2;
        }
        return Math.sqrt(sum);
    }

    public double getManhattanNorm() {
        double manhattanNorm = 0.0;
        double[] dArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            manhattanNorm += Math.abs(v);
            ++n2;
        }
        return manhattanNorm;
    }

    public Vector getProduct(double factor) {
        int size = this.getSize();
        double[] productValues = new double[size];
        int i = 0;
        while (i < size) {
            productValues[i] = factor * this.values[i];
            ++i;
        }
        return new Vector(productValues);
    }

    public int getSize() {
        return this.values.length;
    }

    public Vector getSum(Vector vector) {
        if (!vector.hasSameSizeAs(this)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(vector, "does not have the same size (which is " + vector.getSize() + ") as the current Vector (which has the size " + this.getSize() + ")");
        }
        int size = this.getSize();
        double[] sumValues = new double[size];
        int i = 0;
        while (i < size) {
            sumValues[i] = this.values[i] + vector.values[i];
            ++i;
        }
        return new Vector(sumValues);
    }

    public double getValueAtOneBasedIndex(int oneBasedIndex) {
        Validator.assertThat(oneBasedIndex).thatIsNamed("1-based index").isBetween(1, this.getSize());
        return this.values[oneBasedIndex - 1];
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean hasSameSizeAs(Vector vector) {
        return this.getSize() == vector.getSize();
    }

    public double[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        int i = 0;
        while (i < this.values.length) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.values[i]);
            ++i;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private boolean canEqualVectorBecauseOfSize(Vector vector) {
        return vector != null && this.getSize() == vector.getSize();
    }

    private boolean equalsVector(Vector vector) {
        if (!this.canEqualVectorBecauseOfSize(vector)) {
            return false;
        }
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            if (!NumberComparator.areEqual(this.values[i], vector.values[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

