/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.independent.nolixenvironment;

import ch.nolix.coreapi.environment.nolixenvironment.NolixDirectoryAndFileCatalog;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class NolixEnvironmentService {
    private NolixEnvironmentService() {
    }

    public static String getNolixConfigurationFilePath() {
        NolixEnvironmentService.createFileIfDoesNotExist(NolixDirectoryAndFileCatalog.NOLIX_CONFIGURATION_FILE_PATH);
        return NolixDirectoryAndFileCatalog.NOLIX_CONFIGURATION_FILE_PATH;
    }

    public static String getNolixDirectoryPath() {
        NolixEnvironmentService.createDirectoryIfDoesNotExist(NolixDirectoryAndFileCatalog.NOLIX_DIRECTORY_PATH);
        return NolixDirectoryAndFileCatalog.NOLIX_DIRECTORY_PATH;
    }

    public static String getNolixLicensesDirectoryPath() {
        NolixEnvironmentService.createDirectoryIfDoesNotExist(NolixDirectoryAndFileCatalog.NOLIX_LICENSES_DIRECTORY_PATH);
        return NolixDirectoryAndFileCatalog.NOLIX_LICENSES_DIRECTORY_PATH;
    }

    public static String getNolixLogFilePath() {
        NolixEnvironmentService.createFileIfDoesNotExist(NolixDirectoryAndFileCatalog.NOLIX_LOG_FILE_PATH);
        return NolixDirectoryAndFileCatalog.NOLIX_LOG_FILE_PATH;
    }

    private static void createDirectoryIfDoesNotExist(String path) {
        Path localPath = Path.of(path, new String[0]);
        NolixEnvironmentService.createDirectoryIfDoesNotExist(localPath);
    }

    private static void createDirectoryIfDoesNotExist(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            NolixEnvironmentService.createDirectoryWhenDoesNotExist(path);
        }
    }

    private static void createDirectoryWhenDoesNotExist(Path path) {
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
    }

    private static void createFileIfDoesNotExist(String filePath) {
        Path localFilePath = Path.of(filePath, new String[0]);
        NolixEnvironmentService.createFileIfDoesNotExist(localFilePath);
    }

    private static void createFileIfDoesNotExist(Path filePath) {
        if (!Files.exists(filePath, new LinkOption[0])) {
            NolixEnvironmentService.createFileWhenDoesNotExist(filePath);
        }
    }

    private static void createFileWhenDoesNotExist(Path filePath) {
        try {
            Path directoryPath = filePath.getParent();
            NolixEnvironmentService.createDirectoryIfDoesNotExist(directoryPath);
            Files.createFile(filePath, new FileAttribute[0]);
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
    }
}

