/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.performanceanalysis;

import ch.nolix.core.independent.math.NumberComparator;
import ch.nolix.core.independent.stopwatch.DurationFinder;
import ch.nolix.core.independent.stopwatch.StopWatch;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.LongToDoubleFunction;

public final class PerformanceAnalyzerHelper {
    private PerformanceAnalyzerHelper() {
    }

    public static <O> boolean onObjectsFromObjectSupplierActionRunsAtLeastOnceWithGivenOrLowerTimeComplexity(IntFunction<O> objectSupplier, Consumer<O> action, LongToDoubleFunction timeComplexityFunction) {
        StopWatch stopWatch = StopWatch.createStartedStopWatch();
        int maxRunCount = 5;
        while (stopWatch.getTotalRunningTimeInMilliseconds() < 5000L) {
            boolean resultIsFinal;
            boolean passed = PerformanceAnalyzerHelper.onObjectsFromObjectSupplierUpToMaxRunCountActionRunsWithGivenOrLowerTimeComplexity(objectSupplier, maxRunCount, action, timeComplexityFunction);
            if (passed && (resultIsFinal = PerformanceAnalyzerHelper.resultIsFinalAccordingToTotalRunningTimeInMillisecondsAndTotalRunCount(stopWatch.getTotalRunningTimeInMilliseconds(), maxRunCount))) {
                return true;
            }
            maxRunCount *= 5;
        }
        return false;
    }

    private static <O> boolean onObjectsFromObjectSupplierUpToMaxRunCountActionRunsWithGivenOrLowerTimeComplexity(IntFunction<O> objectSupplier, int maxRunCount, Consumer<O> action, LongToDoubleFunction timeComplexityFunction) {
        double latestTimeComplexityInvariant = 0.0;
        int runCount = 5;
        while (runCount <= maxRunCount) {
            Optional<Double> optionalTimeComplexityInvariant = PerformanceAnalyzerHelper.getOpionalTimeComplexityInvariantOfActionOnObjectFromObjectSupplierByRunCountAndTimeComplexityFunction(objectSupplier, runCount, action, timeComplexityFunction);
            if (optionalTimeComplexityInvariant.isPresent()) {
                Double timeComplexityInvariant = optionalTimeComplexityInvariant.get();
                double goodWillTimeComplexityInvariant = 1.1 * timeComplexityInvariant;
                if (latestTimeComplexityInvariant > 0.0 && goodWillTimeComplexityInvariant < latestTimeComplexityInvariant) {
                    return false;
                }
                latestTimeComplexityInvariant = NumberComparator.isZero(latestTimeComplexityInvariant) ? timeComplexityInvariant : 0.2 * latestTimeComplexityInvariant + 0.8 * timeComplexityInvariant;
            }
            runCount *= 5;
        }
        return true;
    }

    private static <O> Optional<Double> getOpionalTimeComplexityInvariantOfActionOnObjectFromObjectSupplierByRunCountAndTimeComplexityFunction(IntFunction<O> objectSupplier, int runCount, Consumer<O> action, LongToDoubleFunction timeComplexityFunction) {
        int runtimeInMilliseconds = PerformanceAnalyzerHelper.getRuntimeInMillisecondsOfActionOnObjectFromObjectSupplierByRunCount(objectSupplier, runCount, action);
        if (runtimeInMilliseconds > 10) {
            double timeComplexity = timeComplexityFunction.applyAsDouble(runCount);
            double timeComplexityInvariant = timeComplexity / (double)runtimeInMilliseconds;
            return Optional.of(timeComplexityInvariant);
        }
        return Optional.empty();
    }

    private static <O> int getRuntimeInMillisecondsOfActionOnObjectFromObjectSupplierByRunCount(IntFunction<O> objectSupplier, int runCount, Consumer<O> action) {
        Object object = objectSupplier.apply(runCount);
        Runnable actionOnObject = () -> action.accept(object);
        return PerformanceAnalyzerHelper.getRuntimeOfActionInMilliseconds(actionOnObject);
    }

    private static int getRuntimeOfActionInMilliseconds(Runnable actionOnObject) {
        return (int)DurationFinder.getDurationOfActionInMilliseconds(actionOnObject);
    }

    private static boolean resultIsFinalAccordingToTotalRunningTimeInMillisecondsAndTotalRunCount(long totalRunningTimeInMilliseconds, int totalRunCount) {
        if (totalRunningTimeInMilliseconds > 5000L) {
            return totalRunCount >= 25;
        }
        return totalRunCount >= 1953125;
    }
}

