/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.logging;

import ch.nolix.core.errorcontrol.logging.LogEntry;
import ch.nolix.core.errorcontrol.logging.Logger;
import ch.nolix.core.independent.list.List;

final class LogWorker
extends Thread {
    private boolean active = true;
    private final List<LogEntry> logEntries = new List();

    public LogWorker() {
        this.start();
    }

    @Override
    public void run() {
        boolean idle = false;
        long startTimeOfLastIdleInMilliseconds = -1L;
        while (this.active) {
            if (this.containsLogEntries()) {
                idle = false;
                Logger.takeLogEntry(this.getAndRemoveNextLogEntry());
                continue;
            }
            if (!idle) {
                idle = true;
                startTimeOfLastIdleInMilliseconds = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() <= startTimeOfLastIdleInMilliseconds + 1000L) continue;
            this.active = false;
        }
        Logger.removeLogWorker();
    }

    public synchronized boolean containsLogEntries() {
        return !this.logEntries.isEmpty();
    }

    public synchronized void inactivate() {
        this.active = false;
    }

    public synchronized void takeLogEntry(LogEntry logEntry) {
        this.logEntries.addAtBegin(logEntry);
    }

    private synchronized LogEntry getAndRemoveNextLogEntry() {
        LogEntry logEntry = this.logEntries.getStoredFirst();
        this.logEntries.removeFirst();
        return logEntry;
    }
}

