/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.invalidargumentexception;

import ch.nolix.core.errorcontrol.invalidargumentexception.AbstractInvalidArgumentException;
import ch.nolix.coreapi.errorcontrol.exceptionargumentbox.ArgumentNameDto;
import ch.nolix.coreapi.errorcontrol.exceptionargumentbox.ErrorPredicateDto;

public final class UnequalArgumentException
extends AbstractInvalidArgumentException {
    private static final String DEFAULT_VALUE_NAME = Object.class.getSimpleName();

    private UnequalArgumentException(Object argument, Object value) {
        super(argument, new ErrorPredicateDto("does not equal the " + UnequalArgumentException.getNameOfValue(value) + " '" + String.valueOf(value) + "'"));
    }

    private UnequalArgumentException(Object argument, String argumentName, Object value) {
        super(argument, new ArgumentNameDto(argumentName), new ErrorPredicateDto("does not equal the " + UnequalArgumentException.getNameOfValue(value) + " '" + String.valueOf(value) + "'"));
    }

    public static UnequalArgumentException forArgumentAndArgumentNameAndValue(Object argument, String argumentName, Object value) {
        return new UnequalArgumentException(argument, argumentName, value);
    }

    public static UnequalArgumentException forArgumentAndValue(Object argument, Object value) {
        return new UnequalArgumentException(argument, value);
    }

    private static String getNameOfValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("The given value is null.");
        }
        String name = value.getClass().getSimpleName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return DEFAULT_VALUE_NAME;
    }
}

