/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.exceptionargumentpreparator;

import ch.nolix.coreapi.errorcontrol.exceptionargumentpreparator.IExceptionArgumentStringRepresentaionPreparator;

public final class ExceptionArgumentStringRepresentaionPreparator
implements IExceptionArgumentStringRepresentaionPreparator {
    private static final int MAX_STRING_REPRESENTATION_LENGTH = 200;

    @Override
    public String getSmartSpaceEnclosedQuotedStringRepresentationWithMaxLengthOfArgument(Object argument) {
        if (argument == null) {
            return " ";
        }
        String string = this.getStringRepresentationWithMaxLengthOfArgument(argument);
        if (string.isBlank()) {
            return " ";
        }
        return " '" + string + "' ";
    }

    @Override
    public String getStringRepresentationOfArgument(Object argument) {
        if (argument != null) {
            return this.getStringRepresentationOfArgumentWhenIsNotNull(argument);
        }
        return "null";
    }

    @Override
    public String getStringRepresentationWithMaxLengthOfArgument(Object argument) {
        String string = this.getStringRepresentationOfArgument(argument);
        if (string.length() > 200) {
            return string.substring(0, 200) + "\u2026";
        }
        return string;
    }

    private String getStringRepresentationOfArgumentWhenIsNotNull(Object argument) {
        try {
            String string = argument.toString();
            if (string != null) {
                return string;
            }
            return "null";
        }
        catch (Throwable throwable) {
            return "";
        }
    }
}

