/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.exceptionargumentpreparator;

import ch.nolix.coreapi.errorcontrol.exceptionargumentpreparator.IExceptionArgumentNamePreparator;

public final class ExceptionArgumentNamePreparator
implements IExceptionArgumentNamePreparator {
    private static final String DEFAULT_ARGUMENT_NAME = "argument";

    @Override
    public String getNameOfArgument(Object argument) {
        if (argument != null) {
            return ExceptionArgumentNamePreparator.getNameOfArgumentThatIsInstanceOfClass(argument.getClass());
        }
        return DEFAULT_ARGUMENT_NAME;
    }

    @Override
    public String getValidatedArgumentNameFromArgumentName(String argumentName) {
        if (argumentName == null) {
            throw new IllegalArgumentException("The given argument name is null.");
        }
        if (argumentName.isBlank()) {
            throw new IllegalArgumentException("The given argument name is blank.");
        }
        return argumentName;
    }

    private static String getNameOfArgumentThatIsInstanceOfClass(Class<?> paramClass) {
        if (paramClass == null) {
            throw new IllegalArgumentException("The given class is null.");
        }
        String argumentName = paramClass.getSimpleName();
        if (argumentName != null && !argumentName.isEmpty()) {
            return argumentName;
        }
        return DEFAULT_ARGUMENT_NAME;
    }
}

