/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.document.node;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.AbstractMutableNode;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import java.util.function.Predicate;

public final class MutableNode
extends AbstractMutableNode<MutableNode> {
    private String memberHeader;
    private final LinkedList<MutableNode> memberChildNodes = LinkedList.createEmpty();

    private MutableNode() {
    }

    public static MutableNode createEmpty() {
        return new MutableNode();
    }

    public static MutableNode fromFile(String filePath) {
        MutableNode mutableNode = MutableNode.createEmpty();
        mutableNode.resetFromFile(filePath);
        return mutableNode;
    }

    public static MutableNode fromNode(INode<?> node) {
        MutableNode mutableNode = MutableNode.createEmpty();
        if (node.hasHeader()) {
            mutableNode.setHeader(node.getHeader());
        }
        mutableNode.addChildNodes(node.getStoredChildNodes());
        return mutableNode;
    }

    public static MutableNode fromString(String string) {
        MutableNode mutableNode = MutableNode.createEmpty();
        mutableNode.resetFromString(string);
        return mutableNode;
    }

    @Override
    public MutableNode addChildNode(INode<?> childNode, INode<?> ... childNodes) {
        this.memberChildNodes.addAtEnd(MutableNode.fromNode(childNode));
        INode<?>[] iNodeArray = childNodes;
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            INode<?> c = iNodeArray[n2];
            this.memberChildNodes.addAtEnd(MutableNode.fromNode(c));
            ++n2;
        }
        return this;
    }

    @Override
    public MutableNode addChildNodeFromString(String string, String ... strings) {
        this.addChildNode((INode)MutableNode.fromString(string), new INode[0]);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.addChildNode((INode)MutableNode.fromString(s), new INode[0]);
            ++n2;
        }
        return this;
    }

    @Override
    public <N extends INode<?>> MutableNode addChildNodes(Iterable<N> pChildNodes) {
        for (INode c : pChildNodes) {
            this.memberChildNodes.addAtEnd(MutableNode.fromNode(c));
        }
        return this;
    }

    @Override
    public MutableNode addChildNodesFromStrings(Iterable<String> strings) {
        for (String s : strings) {
            this.addChildNode((INode)MutableNode.fromString(s), new INode[0]);
        }
        return this;
    }

    @Override
    public INode<?> asWithHeader(String header) {
        return Node.withHeaderAndChildNodes(header, this.getStoredChildNodes());
    }

    @Override
    public IContainer<MutableNode> getStoredChildNodes() {
        return this.memberChildNodes;
    }

    @Override
    public String getHeader() {
        this.assertHasHeader();
        return this.memberHeader;
    }

    @Override
    public boolean hasHeader() {
        return this.memberHeader != null;
    }

    @Override
    public void removeChildNodes() {
        this.memberChildNodes.clear();
    }

    @Override
    public MutableNode removeAndGetStoredFirstChildNodeThat(Predicate<INode<?>> selector) {
        return this.memberChildNodes.removeAndGetStoredFirst(selector::test);
    }

    @Override
    public void removeFirstChildNodeThat(Predicate<INode<?>> selector) {
        this.memberChildNodes.removeFirst(selector::test);
    }

    @Override
    public void removeFirstChildNodeWithHeader(String header) {
        this.memberChildNodes.removeFirst(cn -> cn.hasHeader(header));
    }

    @Override
    public void removeHeader() {
        this.memberHeader = null;
    }

    @Override
    public void replaceFirstChildNodeWithGivenHeaderByGivenNode(String header, INode<?> childNode) {
        this.memberChildNodes.replaceFirst(a -> a.hasHeader(header), MutableNode.fromNode(childNode));
    }

    @Override
    public void reset() {
        this.removeHeader();
        this.removeChildNodes();
    }

    @Override
    public MutableNode setHeader(String header) {
        Validator.assertThat(header).thatIsNamed("header").isNotBlank();
        this.memberHeader = header;
        return this;
    }

    @Override
    protected MutableNode asConcrete() {
        return this;
    }

    private void assertHasHeader() {
        if (!this.hasHeader()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "header");
        }
    }
}

