/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.document.node;

import ch.nolix.core.document.node.AbstractNode;
import ch.nolix.core.document.node.MutableNode;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.environment.filesystem.FileAccessor;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnrepresentingArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.document.node.INode;

public abstract class AbstractMutableNode<N extends AbstractMutableNode<N>>
extends AbstractNode<N>
implements IMutableNode<N> {
    @Override
    public final N addPostfixToHeader(String postfix) {
        Validator.assertThat(postfix).thatIsNamed("postfix").isNotBlank();
        if (!this.hasHeader()) {
            this.setHeader(postfix);
        } else {
            this.setHeader(this.getHeader() + postfix);
        }
        return this.asConcrete();
    }

    @Override
    public final N addPrefixToHeader(String prefix) {
        Validator.assertThat(prefix).thatIsNamed("prefix").isNotBlank();
        if (!this.hasHeader()) {
            this.setHeader(prefix);
        } else {
            this.setHeader(prefix + this.getHeader());
        }
        return this.asConcrete();
    }

    @Override
    public final void resetFromFile(String filePath) {
        this.resetFromString(new FileAccessor(filePath).readFile().replace(String.valueOf('\t'), "").replace(String.valueOf('\n'), ""));
    }

    @Override
    public final void resetFromNode(INode<?> node) {
        this.reset();
        if (node.hasHeader()) {
            this.setHeader(node.getHeader());
        }
        this.addChildNodes(node.getStoredChildNodes());
    }

    @Override
    public final void resetFromString(String string) {
        this.reset();
        if (this.setFromStringAndStartIndexAndGetEndIndex(string, 0) != string.length() - 1) {
            this.reset();
            throw UnrepresentingArgumentException.forArgumentAndType(string, Node.class);
        }
    }

    @Override
    public final N setChildNodes(Iterable<? extends INode<?>> childNodes) {
        this.removeChildNodes();
        this.addChildNodes(childNodes);
        return this.asConcrete();
    }

    protected abstract N asConcrete();

    final int setFromStringAndStartIndexAndGetEndIndex(String string, int startIndex) {
        MutableNode node;
        int index;
        int headerLength = this.getHeaderLengthFromStringAndStartIndex(string, startIndex);
        if (headerLength > 0) {
            this.setHeader(AbstractMutableNode.getOriginStringFromEscapeString(string.substring(startIndex, startIndex + headerLength)));
        }
        if ((index = startIndex + headerLength) == string.length()) {
            return index - 1;
        }
        char character = string.charAt(index);
        if (character == ',' || character == ')') {
            return index - 1;
        }
        if (index < string.length()) {
            node = MutableNode.createEmpty();
            index = node.setFromStringAndStartIndexAndGetEndIndex(string, index + 1) + 1;
            this.addChildNode(node, new INode[0]);
        }
        while (index < string.length()) {
            switch (string.charAt(index)) {
                case ',': {
                    node = MutableNode.createEmpty();
                    index = node.setFromStringAndStartIndexAndGetEndIndex(string, index + 1) + 1;
                    this.addChildNode(node, new INode[0]);
                    break;
                }
                case ')': {
                    return index;
                }
            }
        }
        throw UnrepresentingArgumentException.forArgumentAndType(string, Node.class);
    }

    private int getHeaderLengthFromStringAndStartIndex(String string, int startIndex) {
        int index = startIndex;
        while (index < string.length()) {
            char character = string.charAt(index);
            if (character == '(' || character == ',' || character == ')') {
                return index - startIndex;
            }
            ++index;
        }
        return string.length() - startIndex;
    }
}

