/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.document.chainednode;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.chainednode.ChainedNodeComparator;
import ch.nolix.core.document.chainednode.ChainedNodeStringHelper;
import ch.nolix.core.document.chainednode.HeaderLengthAndTaskAfterSetHeaderParameter;
import ch.nolix.core.document.chainednode.TaskAfterSetHeader;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnrepresentingArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.document.node.INode;

public final class ChainedNode
implements IChainedNode {
    public static final String DOT_CODE = "$D";
    public static final String COMMA_CODE = "$M";
    public static final String DOLLAR_SYMBOL_CODE = "$X";
    public static final String OPEN_BRACKET_CODE = "$O";
    public static final String CLOSED_BRACKET_CODE = "$C";
    private static final String NEXT_NODE_VARIABLE_NAME = "next node";
    private String memberHeader;
    private ChainedNode nextNode;
    private final LinkedList<ChainedNode> memberChildNodes = LinkedList.createEmpty();

    public ChainedNode() {
        this.memberHeader = null;
        this.nextNode = null;
    }

    public ChainedNode(String header, Iterable<INode<?>> attributes) {
        this.setHeader(header);
        this.addChildNodesFromNodes(attributes);
    }

    public ChainedNode(String header, Iterable<INode<?>> attributes, ChainedNode nextNode) {
        this.setHeader(header);
        this.addChildNodesFromNodes(attributes);
        this.setNextNode(nextNode);
    }

    public static ChainedNode fromChainedNode(IChainedNode chainedNode) {
        if (chainedNode instanceof ChainedNode) {
            ChainedNode localChainedNode = (ChainedNode)chainedNode;
            return localChainedNode;
        }
        ChainedNode newChainedNode = new ChainedNode();
        if (chainedNode.hasHeader()) {
            newChainedNode.setHeader(chainedNode.getHeader());
        }
        newChainedNode.addChildNodes(chainedNode.getChildNodes());
        if (chainedNode.hasNextNode()) {
            newChainedNode.setNextNode(chainedNode.getNextNode());
        }
        return newChainedNode;
    }

    public static ChainedNode fromNode(INode<?> node) {
        ChainedNode chainedNode = new ChainedNode();
        if (node.hasHeader()) {
            chainedNode.setHeader(node.getHeader());
        }
        chainedNode.addChildNodesFromNodes(node.getStoredChildNodes());
        return chainedNode;
    }

    public static ChainedNode fromString(String string) {
        ChainedNode chainedNode = new ChainedNode();
        chainedNode.resetFromString(string);
        return chainedNode;
    }

    public static String getEscapeStringFor(String string) {
        return string.replace(String.valueOf('$'), DOLLAR_SYMBOL_CODE).replace(String.valueOf('.'), DOT_CODE).replace(String.valueOf(','), COMMA_CODE).replace(String.valueOf('('), OPEN_BRACKET_CODE).replace(String.valueOf(')'), CLOSED_BRACKET_CODE);
    }

    public static String getStoredginStringFromEscapeString(String escapeString) {
        return escapeString.replace(DOT_CODE, String.valueOf('.')).replace(COMMA_CODE, String.valueOf(',')).replace(OPEN_BRACKET_CODE, String.valueOf('(')).replace(CLOSED_BRACKET_CODE, String.valueOf(')')).replace(DOLLAR_SYMBOL_CODE, String.valueOf('$'));
    }

    public static ChainedNode withChildNodesFromNodes(INode<?> childNode, INode<?> ... childNodes) {
        ChainedNode chainedNode = new ChainedNode();
        chainedNode.addChildNode(childNode, childNodes);
        return chainedNode;
    }

    public static ChainedNode withChildNodesFromNodes(Iterable<? extends INode<?>> attributes) {
        ChainedNode chainedNode = new ChainedNode();
        chainedNode.addChildNodesFromNodes(attributes);
        return chainedNode;
    }

    public static ChainedNode withHeader(String header) {
        ChainedNode chainedNode = new ChainedNode();
        chainedNode.setHeader(header);
        return chainedNode;
    }

    public static ChainedNode withHeaderAndChildNode(String header, ChainedNode attribute) {
        ChainedNode chainedNode = new ChainedNode();
        chainedNode.setHeader(header);
        chainedNode.addChildNode(attribute, new IChainedNode[0]);
        return chainedNode;
    }

    public static ChainedNode withHeaderAndChildNodes(String header, ChainedNode childNode, ChainedNode ... childNodes) {
        ChainedNode chainedNode = new ChainedNode();
        chainedNode.setHeader(header);
        chainedNode.addChildNode(childNode, childNodes);
        return chainedNode;
    }

    public static ChainedNode withHeaderAndChildNode(String header, INode<?> childNode) {
        ChainedNode chainedNode = new ChainedNode();
        chainedNode.setHeader(header);
        chainedNode.addChildNode(childNode, new INode[0]);
        return chainedNode;
    }

    public static ChainedNode withHeaderAndChildNodes(String header, Iterable<? extends IChainedNode> attributes) {
        ChainedNode chainedNode = new ChainedNode();
        chainedNode.setHeader(header);
        chainedNode.addChildNodes(attributes);
        return chainedNode;
    }

    public static ChainedNode withHeaderAndChildNodesFromNodes(String header, INode<?> childNode, INode<?> ... childNodes) {
        ChainedNode chainedNode = new ChainedNode();
        ContainerView<INode<?>> allChildNodes = ContainerView.forElementAndArray(childNode, childNodes);
        chainedNode.setHeader(header);
        chainedNode.addChildNodesFromNodes(allChildNodes);
        return chainedNode;
    }

    public static ChainedNode withHeaderAndChildNodesFromNodes(String header, Iterable<? extends INode<?>> attributes) {
        ChainedNode chainedNode = new ChainedNode();
        chainedNode.setHeader(header);
        chainedNode.addChildNodesFromNodes(attributes);
        return chainedNode;
    }

    public static ChainedNode withHeaderAndNextNode(String header, ChainedNode nextNode) {
        ChainedNode chainedNode = new ChainedNode();
        chainedNode.setHeader(header);
        chainedNode.setNextNode(nextNode);
        return chainedNode;
    }

    public static ChainedNode withHeaderAndNextNodeAndChildNodes(String header, ChainedNode nextNode, IChainedNode childNode, IChainedNode ... childNodes) {
        ChainedNode chainedNode = new ChainedNode();
        chainedNode.setHeader(header);
        chainedNode.addChildNode(childNode, childNodes);
        chainedNode.setNextNode(nextNode);
        return chainedNode;
    }

    @Override
    public boolean containsChildNodes() {
        return this.memberChildNodes.containsAny();
    }

    public boolean equals(Object object) {
        ChainedNode chainedNode;
        return object instanceof ChainedNode && ChainedNodeComparator.areEqual(this, chainedNode = (ChainedNode)object);
    }

    @Override
    public int getChildNodeCount() {
        return this.memberChildNodes.getCount();
    }

    @Override
    public ChainedNode getChildNodeAtOneBasedIndex(int index) {
        return this.memberChildNodes.getStoredAtOneBasedIndex(index);
    }

    public IContainer<ChainedNode> getChildNodes() {
        return this.memberChildNodes;
    }

    @Override
    public ChainedNode getFirstChildNodeWithHeader(String header) {
        return this.getChildNodes().getStoredFirst(a -> a.hasHeader(header));
    }

    @Override
    public String getHeader() {
        if (this.memberHeader == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "header");
        }
        return this.memberHeader;
    }

    @Override
    public ChainedNode getNextNode() {
        if (this.nextNode == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, NEXT_NODE_VARIABLE_NAME);
        }
        return this.nextNode;
    }

    @Override
    public ChainedNode getSingleChildNode() {
        return (ChainedNode)this.memberChildNodes.getStoredOne();
    }

    @Override
    public String getSingleChildNodeHeader() {
        return this.getSingleChildNode().getHeader();
    }

    @Override
    public double getSingleChildNodeAsDouble() {
        return this.getSingleChildNode().toDouble();
    }

    @Override
    public int getSingleChildNodeAsInt() {
        return this.getSingleChildNode().toInt();
    }

    @Override
    public String getSingleChildNodeAsString() {
        return this.getSingleChildNode().toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean hasHeader() {
        return this.memberHeader != null;
    }

    @Override
    public boolean hasNextNode() {
        return this.nextNode != null;
    }

    @Override
    public boolean isBlank() {
        return !this.hasHeader() && !this.containsChildNodes();
    }

    @Override
    public double toDouble() {
        if (this.memberHeader == null || this.memberChildNodes.containsAny()) {
            throw UnrepresentingArgumentException.forArgumentAndType(this, Integer.class);
        }
        return Double.valueOf(this.memberHeader);
    }

    @Override
    public int toInt() {
        if (!this.hasHeader() || this.containsChildNodes() || this.hasNextNode()) {
            throw UnrepresentingArgumentException.forArgumentAndType(this, Integer.class);
        }
        try {
            return Integer.parseInt(this.getHeader());
        }
        catch (NumberFormatException numberFormatException) {
            throw UnrepresentingArgumentException.forArgumentAndType(this, Integer.class);
        }
    }

    public Node toNode() {
        if (this.nextNode != null) {
            throw UnrepresentingArgumentException.forArgumentAndType(this, Node.class);
        }
        if (!this.hasHeader()) {
            return Node.withChildNodes(this.getChildNodes().getViewOf(ChainedNode::toNode));
        }
        return Node.withHeaderAndChildNodes(this.getHeader(), this.getChildNodes().getViewOf(ChainedNode::toNode));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendStringRepresentationTo(stringBuilder);
        return stringBuilder.toString();
    }

    private void addChildNode(IChainedNode childNode, IChainedNode ... childNodes) {
        if (childNode instanceof ChainedNode) {
            ChainedNode chainedNode = (ChainedNode)childNode;
            this.memberChildNodes.addAtEnd(chainedNode);
        } else {
            this.memberChildNodes.addAtEnd(ChainedNode.fromChainedNode(childNode));
        }
        IChainedNode[] iChainedNodeArray = childNodes;
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IChainedNode c = iChainedNodeArray[n2];
            if (c instanceof ChainedNode) {
                ChainedNode chainedNode = (ChainedNode)c;
                this.memberChildNodes.addAtEnd(chainedNode);
            } else {
                this.memberChildNodes.addAtEnd(ChainedNode.fromChainedNode(c));
            }
            ++n2;
        }
    }

    private void addChildNode(INode<?> childNode, INode<?> ... childNodes) {
        this.memberChildNodes.addAtEnd(ChainedNode.fromNode(childNode));
        INode<?>[] iNodeArray = childNodes;
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            INode<?> c = iNodeArray[n2];
            this.memberChildNodes.addAtEnd(ChainedNode.fromNode(c));
            ++n2;
        }
    }

    private void addChildNodes(Iterable<? extends IChainedNode> childNodes) {
        for (IChainedNode iChainedNode : childNodes) {
            if (iChainedNode instanceof ChainedNode) {
                ChainedNode chainedNode = (ChainedNode)iChainedNode;
                this.memberChildNodes.addAtEnd(chainedNode);
                continue;
            }
            this.memberChildNodes.addAtEnd(ChainedNode.fromChainedNode(iChainedNode));
        }
    }

    private void addChildNodesFromNodes(Iterable<? extends INode<?>> attributes) {
        for (INode<?> a : attributes) {
            this.memberChildNodes.addAtEnd(ChainedNode.fromNode(a));
        }
    }

    private void appendStringRepresentationTo(StringBuilder stringBuilder) {
        if (this.memberHeader != null) {
            stringBuilder.append(ChainedNode.getEscapeStringFor(this.memberHeader));
        }
        if (this.memberChildNodes.containsAny()) {
            stringBuilder.append("(");
            boolean atBegin = true;
            for (ChainedNode a : this.memberChildNodes) {
                if (atBegin) {
                    atBegin = false;
                } else {
                    stringBuilder.append(",");
                }
                a.appendStringRepresentationTo(stringBuilder);
            }
            stringBuilder.append(")");
        }
        if (this.nextNode != null) {
            stringBuilder.append(".");
            this.nextNode.appendStringRepresentationTo(stringBuilder);
        }
    }

    private int mapChildNodesAndPotentialNextNodeFromStingAndStartIndexAndGetNextIndex(String string, int startIndex) {
        int nextIndex = startIndex;
        ChainedNode node = new ChainedNode();
        nextIndex = node.setFromStringAndStartIndexAndGetNextIndex(string, nextIndex);
        this.memberChildNodes.addAtEnd(node);
        while (nextIndex < string.length()) {
            char character = string.charAt(nextIndex);
            if (character == ',') {
                ChainedNode node2 = new ChainedNode();
                nextIndex = node2.setFromStringAndStartIndexAndGetNextIndex(string, nextIndex + 1);
                this.memberChildNodes.addAtEnd(node2);
                continue;
            }
            if (character != ')') continue;
            ++nextIndex;
            break;
        }
        if (nextIndex < string.length() - 1 && string.charAt(nextIndex) == '.') {
            return this.mapNextNodeFromStringAndStartIndexAndGetNextIndex(string, ++nextIndex);
        }
        return nextIndex;
    }

    private int mapNextNodeFromStringAndStartIndexAndGetNextIndex(String string, int startIndex) {
        this.nextNode = new ChainedNode();
        return this.nextNode.setFromStringAndStartIndexAndGetNextIndex(string, startIndex);
    }

    private void reset() {
        this.memberHeader = null;
        this.memberChildNodes.clear();
        this.nextNode = null;
    }

    private void resetFromString(String string) {
        this.reset();
        if (this.setFromStringAndStartIndexAndGetNextIndex(string, 0) != string.length()) {
            this.reset();
            throw UnrepresentingArgumentException.forArgumentAndType(string, ChainedNode.class);
        }
    }

    private int setFromStringAndStartIndexAndGetNextIndex(String string, int startIndex) {
        HeaderLengthAndTaskAfterSetHeaderParameter headerLengthAndTaskAfterSetHeader = ChainedNodeStringHelper.getHeaderLengthAndTaskAfterSetHeader(string, startIndex);
        int headerLength = headerLengthAndTaskAfterSetHeader.getHeaderLength();
        TaskAfterSetHeader taskAfterSetHeader = headerLengthAndTaskAfterSetHeader.getTaskAfterSetHeader();
        this.setPotentialHeaderFromStringAndStartIndexAndHeaderLength(string, startIndex, headerLength);
        int nextIndex = ChainedNodeStringHelper.calculateNextIndexFromStartIndexAndHeaderLengthAndTaskAfterSetHeader(startIndex, headerLength, taskAfterSetHeader);
        return switch (taskAfterSetHeader) {
            case TaskAfterSetHeader.DO_NOTHING -> nextIndex;
            case TaskAfterSetHeader.MAP_NEXT_NODE -> this.mapNextNodeFromStringAndStartIndexAndGetNextIndex(string, nextIndex);
            case TaskAfterSetHeader.MAP_CHILD_NODES_AND_POTENTIAL_NEXT_NODE -> this.mapChildNodesAndPotentialNextNodeFromStingAndStartIndexAndGetNextIndex(string, nextIndex);
            default -> throw new MatchException(null, null);
        };
    }

    private void setHeader(String header) {
        if (header == null) {
            throw ArgumentIsNullException.forArgumentName("header");
        }
        if (header.isBlank()) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate("header", header, "is blank");
        }
        this.memberHeader = header;
    }

    private void setNextNode(IChainedNode nextNode) {
        ChainedNode chainedNode;
        if (nextNode == null) {
            throw ArgumentIsNullException.forArgumentName(NEXT_NODE_VARIABLE_NAME);
        }
        this.nextNode = nextNode instanceof ChainedNode ? (chainedNode = (ChainedNode)nextNode) : ChainedNode.fromChainedNode(nextNode);
    }

    private void setPotentialHeaderFromStringAndStartIndexAndHeaderLength(String string, int startIndex, int headerLength) {
        if (headerLength > 0) {
            this.memberHeader = ChainedNode.getStoredginStringFromEscapeString(string.substring(startIndex, startIndex + headerLength));
        }
    }
}

