/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.datastructure.property;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.datastructure.property.ILazyCalculatedProperty;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public final class LazyCalculatedProperty<V>
implements ILazyCalculatedProperty<V> {
    private final Supplier<V> valueCreator;
    private final BooleanSupplier needToUpdateSupplier;
    private V value;

    private LazyCalculatedProperty(Supplier<V> valueCreator, BooleanSupplier needToUpdateSupplier) {
        Validator.assertThat(valueCreator).thatIsNamed("value creator").isNotNull();
        Validator.assertThat(needToUpdateSupplier).thatIsNamed("need-to-update-supplier").isNotNull();
        this.valueCreator = valueCreator;
        this.needToUpdateSupplier = needToUpdateSupplier;
    }

    public static <V2> LazyCalculatedProperty<V2> forValueCreaterAndNeedToUpdateSupplier(Supplier<V2> valueCreator, BooleanSupplier needToUpdateSupplier) {
        return new LazyCalculatedProperty<V2>(valueCreator, needToUpdateSupplier);
    }

    public static <V2> LazyCalculatedProperty<V2> forValueCreater(Supplier<V2> valueCreator) {
        BooleanSupplier needToUpdateSupplier = () -> true;
        return new LazyCalculatedProperty<V2>(valueCreator, needToUpdateSupplier);
    }

    @Override
    public V getStoredValue() {
        this.updateIfRequired();
        return this.value;
    }

    @Override
    public boolean isUpToDate() {
        return !this.needToUpdateSupplier.getAsBoolean();
    }

    private void updateIfRequired() {
        if (this.updateIsRequired()) {
            this.value = this.valueCreator.get();
        }
    }

    private boolean updateIsRequired() {
        return this.value == null || this.isOutOfDate();
    }
}

