/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.datastructure.pair;

import ch.nolix.core.commontypetool.stringtool.StringTool;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.coreapi.datastructure.pair.IKeyValuePair;

public final class KeyValuePair<K, V>
implements IKeyValuePair<K, V> {
    private final K key;
    private final V value;

    private KeyValuePair(K key, V value) {
        if (key == null) {
            throw ArgumentIsNullException.forArgumentName("key");
        }
        if (value == null) {
            throw ArgumentIsNullException.forArgumentName("value");
        }
        this.key = key;
        this.value = value;
    }

    public static <K2, V2> KeyValuePair<K2, V2> withKeyAndValue(K2 key, V2 value) {
        return new KeyValuePair<K2, V2>(key, value);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getStoredValue() {
        return this.value;
    }

    public String toString() {
        return StringTool.getInParentheses(String.valueOf(this.key) + ";" + String.valueOf(this.value), new Object[0]);
    }
}

