/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.sequencesearch;

import ch.nolix.core.container.arraylist.ArrayList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.sequencesearch.ISequencePattern;
import ch.nolix.coreapi.container.sequencesearch.ISequencePatternNextMediator;
import java.util.function.Predicate;

public final class SequencePatternNextMediator<E>
implements ISequencePatternNextMediator<E> {
    private final ISequencePattern<E> sequencePattern;
    private final int count;
    private final Predicate<E> blankCondition = object -> true;

    private SequencePatternNextMediator(ISequencePattern<E> sequencePattern, int count) {
        Validator.assertThat(sequencePattern).thatIsNamed(ISequencePattern.class).isNotNull();
        Validator.assertThat(count).thatIsNamed("count").isNotNegative();
        this.sequencePattern = sequencePattern;
        this.count = count;
    }

    public static <T> SequencePatternNextMediator<T> forSequencePatternAndCount(ISequencePattern<T> sequencePattern, int count) {
        return new SequencePatternNextMediator<T>(sequencePattern, count);
    }

    @Override
    public ISequencePattern<E> withBlank() {
        IContainer<Predicate<E>> blanks = this.createBlanks(this.count);
        return this.sequencePattern.withConditionsForNexts(blanks);
    }

    @Override
    public ISequencePattern<E> withCondition(Predicate<E> condition) {
        ArrayList<Predicate<Predicate<E>>> conditions = ArrayList.withInitialCapacity(this.count);
        int i = 1;
        while (i < this.count) {
            conditions.addAtEnd(condition);
            ++i;
        }
        return this.sequencePattern.withConditionsForNexts(conditions);
    }

    private IContainer<Predicate<E>> createBlanks(int paramCount) {
        ArrayList<Predicate<Predicate<E>>> blanks = ArrayList.withInitialCapacity(paramCount);
        int i = 1;
        while (i < paramCount) {
            blanks.addAtEnd(this.blankCondition);
            ++i;
        }
        return blanks;
    }
}

