/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.matrix;

import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.container.matrix.MatrixColumn;
import ch.nolix.core.container.matrix.MatrixIterator;
import ch.nolix.core.container.matrix.MatrixRow;
import ch.nolix.core.errorcontrol.invalidargumentexception.EmptyArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import ch.nolix.coreapi.container.matrix.IMatrix;
import java.util.Arrays;
import java.util.function.Function;

public final class Matrix<E>
extends AbstractExtendedContainer<E>
implements IMatrix<E> {
    private Object[][] memberElements = new Object[0][0];

    private Matrix() {
    }

    public static <T> Matrix<T> createEmpty() {
        return new Matrix();
    }

    public static <T> Matrix<T> fromMatrix(IMatrix<T> matrix) {
        Matrix newMatrix = new Matrix();
        for (IContainer iContainer : matrix.getRows()) {
            newMatrix.addRow(iContainer);
        }
        return newMatrix;
    }

    public Matrix<E> addColumn(E element, E ... elements) {
        ContainerView<E> allElements = ContainerView.forElementAndArray(element, elements);
        return this.addColumn(allElements);
    }

    public Matrix<E> addColumn(Iterable<E> elements) {
        block3: {
            ContainerView<E> lElements;
            block2: {
                Validator.assertThatTheElements(elements).areNotNull();
                lElements = ContainerView.forIterable(elements);
                if (!this.isEmpty()) break block2;
                if (!lElements.containsAny()) break block3;
                this.memberElements = new Object[lElements.getCount()][1];
                int i = 0;
                for (Object e : lElements) {
                    this.memberElements[i][0] = e;
                    ++i;
                }
                break block3;
            }
            Validator.assertThat(lElements.getCount()).thatIsNamed("number of the given elements").isEqualTo(this.getRowCount());
            int columnCount = this.getColumnCount();
            int i = 0;
            for (Object e : lElements) {
                Object[] row = Arrays.copyOf(this.memberElements[i], columnCount + 1);
                row[columnCount] = e;
                this.memberElements[i] = row;
                ++i;
            }
        }
        return this;
    }

    public Matrix<E> addRow(E ... elements) {
        ContainerView<E> elementsContainerView = ContainerView.forArray(elements);
        return this.addRow(elementsContainerView);
    }

    public Matrix<E> addRow(Iterable<E> elements) {
        Validator.assertThatTheElements(elements).areNotNull();
        ContainerView<E> lElements = ContainerView.forIterable(elements);
        if (this.isEmpty()) {
            if (lElements.containsAny()) {
                this.memberElements = new Object[1][lElements.getCount()];
                int i = 0;
                for (Object e : lElements) {
                    this.memberElements[0][i] = e;
                    ++i;
                }
            }
        } else {
            Validator.assertThat(lElements.getCount()).thatIsNamed("number of the given elements").isEqualTo(this.getColumnCount());
            int rowCount = this.getRowCount();
            Object[][] newElements = (Object[][])Arrays.copyOf(this.memberElements, rowCount + 1);
            newElements[rowCount] = new Object[this.getColumnCount()];
            int i = 0;
            for (Object e : lElements) {
                newElements[rowCount][i] = e;
                ++i;
            }
            this.memberElements = newElements;
        }
        return this;
    }

    @Override
    public void clear() {
        this.memberElements = new Object[0][0];
    }

    public MatrixColumn<E> getColumn(int columnIndex) {
        return new MatrixColumn(this, columnIndex);
    }

    @Override
    public int getColumnCount() {
        if (this.memberElements.length < 1) {
            return 0;
        }
        return this.memberElements[0].length;
    }

    public int getColumnIndexOf(int index) {
        this.assertContainsAt(index);
        int columnCount = this.getColumnCount();
        if (columnCount == 0) {
            throw EmptyArgumentException.forArgument(this);
        }
        return (index - 1) % columnCount + 1;
    }

    @Override
    public IContainer<MatrixColumn<E>> getColumns() {
        LinkedList columns = LinkedList.createEmpty();
        int i = 1;
        while (i <= this.getColumnCount()) {
            columns.addAtEnd(new MatrixColumn(this, i));
            ++i;
        }
        return columns;
    }

    public Matrix<E> getCopy() {
        Matrix<E> matrix = new Matrix<E>();
        int rowCounnt = this.getRowCount();
        int columnCount = this.getColumnCount();
        matrix.memberElements = new Object[rowCounnt][columnCount];
        int i = 0;
        while (i < rowCounnt) {
            matrix.memberElements[i] = Arrays.copyOf(this.memberElements[i], columnCount);
            ++i;
        }
        return matrix;
    }

    @Override
    public int getCount() {
        return this.getRowCount() * this.getColumnCount();
    }

    public int getIndexOf(int rowIndex, int columnIndex) {
        this.assertContainsAt(rowIndex, columnIndex);
        return (rowIndex - 1) * this.getColumnCount() + columnIndex;
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        return this.getStoredAtOneBasedRowIndexAndColumnIndex(this.getRowIndexOf(oneBasedIndex), this.getColumnIndexOf(oneBasedIndex));
    }

    @Override
    public E getStoredAtOneBasedRowIndexAndColumnIndex(int oneBasedRowIndex, int oneBasedColumnIndex) {
        this.assertContainsAt(oneBasedRowIndex, oneBasedColumnIndex);
        return (E)this.memberElements[oneBasedRowIndex - 1][oneBasedColumnIndex - 1];
    }

    public MatrixRow<E> getRow(int rowIndex) {
        return new MatrixRow(this, rowIndex);
    }

    public int getRowIndexOf(int index) {
        this.assertContainsAt(index);
        int columnCount = this.getColumnCount();
        if (columnCount == 0) {
            throw EmptyArgumentException.forArgument(this);
        }
        return (index - 1) / columnCount + 1;
    }

    @Override
    public IContainer<MatrixRow<E>> getRows() {
        LinkedList rows = LinkedList.createEmpty();
        int i = 1;
        while (i <= this.getRowCount()) {
            rows.addAtEnd(new MatrixRow(this, i));
            ++i;
        }
        return rows;
    }

    @Override
    public int getRowCount() {
        if (this.memberElements.length < 1) {
            return 0;
        }
        return this.memberElements.length;
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return MatrixIterator.forMatrix(this);
    }

    public void setAt(int index, E element) {
        Validator.assertThat(element).thatIsNamed("element").isNotNull();
        this.memberElements[this.getRowIndexOf((int)index) - 1][this.getColumnIndexOf((int)index) - 1] = element;
    }

    @Override
    public void setAtOneBasedRowIndexAndColumnIndex(int oneBasedRowIndex, int oneBasedColumnIndex, E element) {
        this.assertContainsAt(oneBasedRowIndex, oneBasedColumnIndex);
        Validator.assertThat(element).thatIsNamed("element").isNotNull();
        this.memberElements[oneBasedRowIndex - 1][oneBasedColumnIndex - 1] = element;
    }

    public <O> Matrix<O> toMatrix(Function<E, O> transformer) {
        Matrix<E> matrix = new Matrix<E>();
        matrix.memberElements = new Object[this.getRowCount()][this.getColumnCount()];
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                matrix.memberElements[i][j] = transformer.apply(this.memberElements[i][j]);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public Matrix<E> toLeftRotatedMatrix() {
        Matrix<E> leftRotatedMatrix = new Matrix<E>();
        int leftRotatedMatrixRowCount = this.getColumnCount();
        int leftRotatedMatrixColumnCount = this.getRowCount();
        Object[][] leftRotatedMatrixElements = new Object[leftRotatedMatrixRowCount][leftRotatedMatrixColumnCount];
        leftRotatedMatrix.memberElements = leftRotatedMatrixElements;
        int i = 0;
        while (i < leftRotatedMatrixRowCount) {
            int j = 0;
            while (j < leftRotatedMatrixColumnCount) {
                leftRotatedMatrixElements[i][j] = this.memberElements[j][leftRotatedMatrixRowCount - i - 1];
                ++j;
            }
            ++i;
        }
        return leftRotatedMatrix;
    }

    public Matrix<E> toRightRotatedMatrix() {
        Matrix<E> rightRotatedMatrix = new Matrix<E>();
        int rightRotatedMatrixRowCount = this.getColumnCount();
        int rightRotatedMatrixColumnCount = this.getRowCount();
        Object[][] rightRotatedMatrixElements = new Object[rightRotatedMatrixRowCount][rightRotatedMatrixColumnCount];
        rightRotatedMatrix.memberElements = rightRotatedMatrixElements;
        int i = 0;
        while (i < rightRotatedMatrixRowCount) {
            int j = 0;
            while (j < rightRotatedMatrixColumnCount) {
                rightRotatedMatrixElements[i][j] = this.memberElements[rightRotatedMatrixColumnCount - j - 1][i];
                ++j;
            }
            ++i;
        }
        return rightRotatedMatrix;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < this.getRowCount()) {
            if (i > 0) {
                stringBuilder.append(';');
            }
            int j = 0;
            while (j < this.getColumnCount()) {
                if (j > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.memberElements[i][j].toString());
                ++j;
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    private void assertContainsAt(int index) {
        Validator.assertThat(index).thatIsNamed("index").isPositive();
        Validator.assertThat(index).thatIsNamed("index").isNotBiggerThan(this.getCount());
    }

    private void assertContainsAt(int rowIndex, int columnIndex) {
        Validator.assertThat(rowIndex).thatIsNamed("row index").isPositive();
        Validator.assertThat(rowIndex).thatIsNamed("row index").isNotBiggerThan(this.getRowCount());
        Validator.assertThat(columnIndex).thatIsNamed("column index").isPositive();
        Validator.assertThat(columnIndex).thatIsNamed("column index").isNotBiggerThan(this.getColumnCount());
    }
}

